(* $Id: draw.ml,v 8.4 91/06/17 12:14:12 ddr Exp $
 *
 * Rogloglo Toolkit: drawing routines
 *
 * $Log:	draw.ml,v $
 * Revision 8.4  91/06/17  12:14:12  ddr
 * *** empty log message ***
 * 
 * Revision 8.3  91/06/17  10:07:20  ddr
 * - merge avec zinc
 * 
 * Revision 8.2  91/06/15  15:57:13  ddr
 * - evolution
 * 
 * Revision 8.1  91/06/15  10:10:33  ddr
 * - merge avec zinc
 * 
 * Revision 7.2  91/05/31  17:20:23  ddr
 * - sauvegarde version
 *)

#standard arith false;;
#fast arith false;;

let XDrawPoint _ =
  display_string "XDrawPoint not implemented";
  display_newline();
  void
;;

let rt_draw_point(draw, x, y) =
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  XDrawPoint(xdm.dpy, draw, xdm.gc, CINT x, CINT y);
  ()

and rt_draw_line(draw, x1, y1, x2, y2) =
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  XDrawLine(xdm.dpy, draw, xdm.gc, CINT x1, CINT y1, CINT x2, CINT y2);
  ()

and rt_draw_lines =
  let pts = mallocated_var (fun _ -> alloc_XPoint (CINT 20)) (ref None) in
function (draw, points) ->
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  let pts = pts() in
  do_list_i (fun i (x, y) ->
    let ii = CINT i in
    set_XPoint_x(CSHORT x, pts, ii);
    set_XPoint_y(CSHORT y, pts, ii)
  ) 0 points;
  XDrawLines(xdm.dpy, draw, xdm.gc, pts, CINT(length points),
      CoordModeOrigin);
  ()

and rt_fill_polygon =
  let pts = mallocated_var (fun _ -> alloc_XPoint (CINT 20)) (ref None) in
function (draw, points) ->
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  let pts = pts() in
  do_list_i (fun i (x, y) ->
    let ii = CINT i in
    set_XPoint_x(CSHORT x, pts, ii);
    set_XPoint_y(CSHORT y, pts, ii)
  ) 0 points;
  XFillPolygon(xdm.dpy, draw, xdm.gc, pts, CINT(length points),
      Convex, CoordModeOrigin);
  ()

and rt_fill_rectangle(draw, x, y, width, height) =
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  XFillRectangle(xdm.dpy, draw, xdm.gc, CINT x, CINT y,
      CINT width, CINT height);
  ()

and rt_draw_rectangle(draw, x, y, width, height) =
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  XDrawRectangle(xdm.dpy, draw, xdm.gc, CINT x, CINT y,
    CINT width, CINT height);
  ()

and rt_clear_area(draw, x, y, width, height) =
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  XClearArea(xdm.dpy, draw, CINT x, CINT y, CINT width, CINT height,
      Zero_Int);
  ()

and rt_draw_string(draw, x, y, str) =
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  XDrawImageString(xdm.dpy, draw, xdm.gc,
    CINT x, CINT y, str, CINT(length_string(str))
  );
  ()
;;

let rt_set_backing_store =
  let xswa = mallocated_var alloc_XSetWindowAttributes (ref None) in
function wid ->
  let xswa = xswa() in
  set_XSetWindowAttributes_backing_store(Always, xswa);
  XChangeWindowAttributes(wid.wid_xd.xdm.dpy, wid.win, CWBackingStore, xswa);
  ()
;;
