(* $Id: c_title.ml,v 8.3 91/06/19 19:39:40 ddr Exp $
 *
 * Rogloglo Toolkit: title widget class
 *
 * $Log:	c_title.ml,v $
 * Revision 8.3  91/06/19  19:39:40  ddr
 * - merge avec zinc 1.4
 * 
 * Revision 8.2  91/06/15  15:54:16  ddr
 * - evolution
 * 
 * Revision 8.1  91/06/15  10:04:10  ddr
 * - merge avec zinc
 * 
 * Revision 7.6  91/06/07  20:14:41  ddr
 * - redistrib
 *)

#standard arith false;;
#fast arith false;;

type title_global_info = {
  tfs       : font_struct;
  gc_title  : GC
}
;;

let title_global_info, get_title_global_info = dynamo_global_info
  "title_global_info" (ref None: title_global_info option ref)
;;

let title_border = ref 1
and title_band = ref 2
and title_font = ref "*-helvetica-bold-o-*--14-*"
;;

let TitleA attr txt =

  let szh = it_list (fun(w,h,b as szh) -> function
    C'WidthAtt v -> (Some v,h,b)
  | C'HeightAtt v -> (w,Some v,b)
  | C'BorderAtt v -> (w,h,Some v)
  | _ -> szh) (None,None,None) attr in

{
  wsize = (function xdm ->
    let make_global_info xdm =
      let fs = load_query_font(xdm, !title_font) in
      let mask = Long_OR(GCForeground, Long_OR(GCBackground, GCFont))
      and gstr = gstr() in
      set_XGCValues_font(fs.fid, gstr.xgcv);
      set_XGCValues_foreground(xdm.black, gstr.xgcv);
      set_XGCValues_background(xdm.white, gstr.xgcv);
      let gc_title = XCreateGC(xdm.dpy, xdm.rootw, mask, gstr.xgcv) in
      xdm.end_func <- (function () ->
        let gi = get_title_global_info(ginfo xdm "title") in
        XFreeGC(xdm.dpy, gi.gc_title);
        XFreeFont(xdm.dpy, gi.tfs.fs);
        remove_ginfo xdm "title";
        ()
      ) :: xdm.end_func;
      add_ginfo xdm "title" title_global_info {
        tfs = fs;
        gc_title = gc_title
      }
    in
    let gi =
      try get_title_global_info(ginfo xdm "title")
      with _ -> make_global_info xdm in
    let w = max (match szh with (Some v,_,_) -> v | _ -> 1) (
      2*!title_band+
        num_of_C_Int(XTextWidth(gi.tfs.fs, txt, CINT(length_string txt))))
    and h = max (match szh with (_,Some v,_) -> v | _ -> 1) (
      2*!title_band+gi.tfs.fheight)
    and b = match szh with (_,_,Some v) -> v | _ -> !title_border
    in (w,h,b)
  )
;
  wcreate = (function (xd, pwin, wdesc, x, y, width, height, border) ->
    let xdm = xd.xdm in
    let win = create_window(
      xdm, pwin, x, y, width, height, border, attr,
      it_list (curry Long_OR) Zero_Long [
        ExposureMask; StructureNotifyMask
      ]
    ) in
    add_widget attr win {
      wid_xd = xd; win = win;
      x = x; y = y; width = width; height = height; border = border;
      wdesc = wdesc; is_mapped = false;
      info = no_info; user_info = no_info;
      children = []
    }
  )
;
  wdestroy = (function wid ->
    remove_widget attr wid.win wid
  )
;
  wdispatch = (function (wid, xev, param) ->
    let xdm = wid.wid_xd.xdm in
    let gi = get_title_global_info(ginfo xdm "title")
    and t = XEvent_type xev in
    if t = Expose then (
      XClearWindow(xdm.dpy, wid.win);
      let len = length_string txt in
      XDrawString(xdm.dpy, wid.win, gi.gc_title,
        CINT((wid.width-num_of_C_Int(XTextWidth(gi.tfs.fs, txt, CINT len)))
          quo 2),
        CINT((wid.height+gi.tfs.ascent-gi.tfs.descent) quo 2),
        txt, CINT len
      );
      ()
    ) else if t = ConfigureNotify then (
      let xev = XEvent_xconfigure xev in
      wid.width <- num_of_C_Int(XConfigureEvent_width xev);
      wid.height <- num_of_C_Int(XConfigureEvent_height xev);
      ()
    );
    param
  )
;
  filler = mem C'FillerAtt attr
}
;;

let TitleD = TitleA []
;;
