(* $Id: c_button.ml,v 8.3 91/06/20 11:14:42 ddr Exp $
 *
 * Rogloglo Toolkit: button widget class
 *
 * $Log:	c_button.ml,v $
 * Revision 8.3  91/06/20  11:14:42  ddr
 * - merge avec zinc 1.6
 * 
 * Revision 8.2  91/06/15  15:42:13  ddr
 * - evolution
 * 
 * Revision 8.1  91/06/15  09:43:01  ddr
 * - merge avec zinc
 * 
 * Revision 7.9  91/06/07  20:14:29  ddr
 * - redistrib
 *)

#standard arith false;;
#fast arith false;;

type button_global_info = {
  bfs                     : font_struct;
  gc_normal               : GC;
  gc_invert               : GC;
  gc_bold                 : GC
}
;;

let button_global_info, get_button_global_info = dynamo_global_info
  "button_global_info" (ref None: button_global_info option ref)
;;

let button_border = ref 2
and button_band = ref 1
and button_bold = ref 2
and button_font = ref "*-helvetica-bold-r-*--14-*";;

let trace_ev ev =
(*
  display_string "-- button ";
  display_string ev;
  display_newline()
*)()

and trace_exp exp =
(*
  display_string "<button ";
  display_string exp;
  display_string ">";
  display_newline()
*)()

and strange_ev ev st =
(*
  display_string "*** button strange event: ";
  display_string ev;
  display_string " while status was: ";
  display_string st;
  display_newline()
*)()
;;

let select_mask = it_list (curry Long_OR) Zero_Long [
  ExposureMask; EnterWindowMask; LeaveWindowMask;
  ButtonPressMask; ButtonReleaseMask; StructureNotifyMask
];;

let GenButtonA popup comm attr (txt, act) =

  let szh = it_list (fun(w,h,b as szh) -> function
    C'WidthAtt v -> (Some v,h,b)
  | C'HeightAtt v -> (w,Some v,b)
  | C'BorderAtt v -> (w,h,Some v)
  | _ -> szh) (None,None,None) attr in

{
  wsize = (function xdm ->
    let make_global_info xdm =
      let fs = load_query_font(xdm, !button_font) in
      let mask = Long_OR(
        Long_OR(GCForeground, GCBackground),
        Long_OR(GCLineWidth, GCCapStyle)
      ) in
      let gstr = gstr() in
      set_XGCValues_foreground(xdm.black, gstr.xgcv);
      set_XGCValues_background(xdm.white, gstr.xgcv);
      set_XGCValues_line_width(CINT !button_bold, gstr.xgcv);
      set_XGCValues_cap_style(CapProjecting, gstr.xgcv);
      let gc_bold = XCreateGC(xdm.dpy, xdm.rootw, mask, gstr.xgcv) in
      let mask = Long_OR(GCForeground, Long_OR(GCBackground, GCFont)) in
      set_XGCValues_font(fs.fid, gstr.xgcv);
      set_XGCValues_foreground(xdm.black, gstr.xgcv);
      set_XGCValues_background(xdm.white, gstr.xgcv);
      let gc_normal = XCreateGC(xdm.dpy, xdm.rootw, mask, gstr.xgcv) in
      set_XGCValues_foreground(xdm.white, gstr.xgcv);
      set_XGCValues_background(xdm.black, gstr.xgcv);
      let gc_invert = XCreateGC(xdm.dpy, xdm.rootw, mask, gstr.xgcv) in
      xdm.end_func <- (function () ->
        let gi = get_button_global_info(ginfo xdm "button") in
        XFreeGC(xdm.dpy, gi.gc_bold);
        XFreeGC(xdm.dpy, gi.gc_invert);
        XFreeGC(xdm.dpy, gi.gc_normal);
        XFreeFont(xdm.dpy, gi.bfs.fs);
        remove_ginfo xdm "button";
        ()
      ) :: xdm.end_func;
      add_ginfo xdm "button" button_global_info {
        bfs = fs;
        gc_normal = gc_normal;
        gc_invert = gc_invert;
        gc_bold = gc_bold
      }
    in
    let gi =
      try get_button_global_info(ginfo xdm "button")
      with _ -> make_global_info xdm in
    let w = max (match szh with (Some v,_,_) -> v | _ -> 1) (
      2*(!button_band+!button_bold)+
        num_of_C_Int(XTextWidth(gi.bfs.fs, txt, CINT(length_string txt))))
    and h = max (match szh with (_,Some v,_) -> v | _ -> 1) (
      2*(!button_band+!button_bold)+gi.bfs.fheight)
    and b = match szh with (_,_,Some v) -> v | _ ->
      if comm then 0 else !button_border
    in (w,h,b)
  )
;
  wcreate = (function (xd, pwin, wdesc, x, y, width, height, border) ->
    let win = create_window(xd.xdm, pwin, x, y, width, height, border, attr,
      if popup then Long_OR(select_mask, OwnerGrabButtonMask)
      else select_mask
    ) in
    add_widget attr win {
      wid_xd = xd; win = win;
      x = x; y = y; width = width; height = height; border = border;
      wdesc = wdesc; is_mapped = false;
      info = no_info; user_info = no_info;
      children = []
    }
  )
;
  wdestroy = (function wid ->
    let xdm = wid.wid_xd.xdm in
    (match xdm.win_but with
      C'WB_Win win -> if eq(win, wid.win) then (xdm.win_but <- C'WB_None; ())
    | _ -> ());
    remove_widget attr wid.win wid
  )
;
  wdispatch = (function (wid, xev, param) ->
    let xdm = wid.wid_xd.xdm in
    let gi = get_button_global_info(ginfo xdm "button") in
    let exp_text() =
      XClearWindow(xdm.dpy, wid.win);
      let len = CINT(length_string txt) in
      XDrawString(xdm.dpy, wid.win, gi.gc_normal,
        (if comm then CINT(!button_bold+!button_band) else
        CINT((wid.width-num_of_C_Int(XTextWidth(gi.bfs.fs, txt, len))) quo 2)),
        CINT((wid.height+gi.bfs.ascent-gi.bfs.descent) quo 2),
        txt, len);
      param
    and exp_high() =
      trace_exp "highlight";
      let T = 0 in
      XDrawRectangle(xdm.dpy, wid.win, gi.gc_bold,
        CINT((!button_bold quo 2)+T), CINT((!button_bold quo 2)+T),
        CINT(wid.width-!button_bold-2*T), CINT(wid.height-!button_bold-2*T));
      param
    and exp_nohigh() =
      trace_exp "nohighlight";
      XClearWindow(xdm.dpy, wid.win);
      let len = CINT(length_string txt) in
      XDrawString(xdm.dpy, wid.win, gi.gc_normal,
        (if comm then CINT(!button_bold+!button_band) else
        CINT((wid.width-num_of_C_Int(XTextWidth(gi.bfs.fs, txt, len))) quo 2)),
        CINT((wid.height+gi.bfs.ascent-gi.bfs.descent) quo 2),
        txt, len);
      param
    and exp_inv() =
      trace_exp "invert";
      XFillRectangle(
        xdm.dpy, wid.win, gi.gc_normal, Zero_Int, Zero_Int,
        CINT wid.width, CINT wid.height);
      let len = CINT(length_string txt) in
      XDrawString(xdm.dpy, wid.win, gi.gc_invert,
        (if comm then CINT(!button_bold+!button_band) else
        CINT((wid.width-num_of_C_Int(XTextWidth(gi.bfs.fs, txt, len))) quo 2)),
        CINT((wid.height+gi.bfs.ascent-gi.bfs.descent) quo 2),
        txt, len);
      param
    in
    let t = XEvent_type xev in
    if t = Expose then exp_text()
    else if t = EnterNotify then (
      trace_ev "EnterNotify";
      match xdm.win_but with
        C'WB_None -> xdm.win_but <- C'WB_Win wid.win; exp_high()
      | C'WB_Win win -> strange_ev "EnterNotify" "C'WB_Win"; param
      | C'WB_WinBut win -> strange_ev "EnterNotify" "C'WB_WinBut"; param
      | C'WB_WinButExit win ->
          if win = wid.win or comm then (
            xdm.win_but <- C'WB_WinBut wid.win;
            exp_inv()
          )
          else if popup then (
            xdm.win_but <- C'WB_WinBut wid.win;
            exp_inv();
            let xev = XEvent_xcrossing xev in
            xdm.xevent.x_win <- num_of_C_Int(XCrossingEvent_x xev);
            xdm.xevent.y_win <- num_of_C_Int(XCrossingEvent_y xev);
            xdm.xevent.x_root <- num_of_C_Int(XCrossingEvent_x_root xev);
            xdm.xevent.y_root <- num_of_C_Int(XCrossingEvent_y_root xev);
            act wid
          )
          else (
            xdm.win_but <- C'WB_WinButOther win;
            param
          )
      | C'WB_WinButOther win ->
          strange_ev "EnterNotify" "C'WB_WinButOther"; param
      | C'WB_But -> xdm.win_but <- C'WB_ButWin; param
      | C'WB_ButWin -> strange_ev "EnterNotify" "C'WB_ButWin"; param
    )
    else if t = LeaveNotify then (
      trace_ev "LeaveNotify";
      match xdm.win_but with
        C'WB_None -> (*strange_ev "LeaveNotify" "C'WB_None";*) param
      | C'WB_Win win -> xdm.win_but <- C'WB_None; exp_nohigh()
      | C'WB_WinBut win -> xdm.win_but <- C'WB_WinButExit win; exp_text()
      | C'WB_WinButExit win ->
          do_list (fun win -> XUnmapWindow(xdm.dpy, win)) xdm.popped_up;
          xdm.popped_up <- []; xdm.win_but <- C'WB_None;
          param
      | C'WB_WinButOther win -> xdm.win_but <- C'WB_WinButExit win; param
      | C'WB_But -> strange_ev "LeaveNotify" "C'WB_But"; param
      | C'WB_ButWin -> xdm.win_but <- C'WB_But; param
    )
    else if t = ButtonPress then (
      trace_ev "ButtonPress";
      match xdm.win_but with
        C'WB_None -> strange_ev "ButtonPress" "C'WB_None"; param
      | C'WB_Win win -> xdm.win_but <- C'WB_WinBut win; exp_inv();
          if popup then (
            let xev = XEvent_xbutton xev in
            xdm.xevent.x_win <- num_of_C_Int(XButtonEvent_x xev);
            xdm.xevent.y_win <- num_of_C_Int(XButtonEvent_y xev);
            xdm.xevent.x_root <- num_of_C_Int(XButtonEvent_x_root xev);
            xdm.xevent.y_root <- num_of_C_Int(XButtonEvent_y_root xev);
            xdm.xevent.button <- num_of_C_Int(XButtonEvent_button xev);
            act wid
          ) else param
      | C'WB_WinBut win -> strange_ev "ButtonPress" "C'WB_WinBut"; param
      | C'WB_WinButExit win -> strange_ev "ButtonPress" "C'WB_WinButExit"; param
      | C'WB_WinButOther win ->
          strange_ev "ButtonPress" "C'WB_WinButOther"; param
      | C'WB_But -> strange_ev "ButtonPress" "C'WB_But"; param
      | C'WB_ButWin -> strange_ev "ButtonPress" "C'WB_ButWin"; param
    )
    else if t = ButtonRelease then (
      trace_ev "ButtonRelease";
      do_list (fun win -> XUnmapWindow(xdm.dpy, win)) xdm.popped_up;
      xdm.popped_up <- [];
      match xdm.win_but with
        C'WB_None -> strange_ev "ButtonRelease" "C'WB_None"; param
      | C'WB_Win win -> (*strange_ev "ButtonRelease" "C'WB_Win"; *) param
      | C'WB_WinBut win -> xdm.win_but <- C'WB_Win win; exp_text(); exp_high();
          if popup then param
          else (
            let xev = XEvent_xbutton xev in
            xdm.xevent.x_win <- num_of_C_Int(XButtonEvent_x xev);
            xdm.xevent.y_win <- num_of_C_Int(XButtonEvent_y xev);
            xdm.xevent.x_root <- num_of_C_Int(XButtonEvent_x_root xev);
            xdm.xevent.y_root <- num_of_C_Int(XButtonEvent_y_root xev);
            xdm.xevent.button <- num_of_C_Int(XButtonEvent_button xev);
            act wid
          )
      | C'WB_WinButExit win -> xdm.win_but <- C'WB_None; param
      | C'WB_WinButOther win -> xdm.win_but <- C'WB_Win wid.win; exp_high()
      | C'WB_But -> xdm.win_but <- C'WB_None; param
      | C'WB_ButWin -> xdm.win_but <- C'WB_Win wid.win; exp_high()
    )
    else if t = ConfigureNotify then (
      let xev = XEvent_xconfigure xev in
      wid.width <- num_of_C_Int(XConfigureEvent_width xev);
      wid.height <- num_of_C_Int(XConfigureEvent_height xev);
      param
    )
    else param
  )
;
  filler = mem C'FillerAtt attr
}
;;

let ButtonA = GenButtonA false false
and PopupA = GenButtonA true false
and CommA = GenButtonA false true
;;

let ButtonD = ButtonA []
and PopupD = PopupA []
and CommD = CommA []
;;
