(*
 * Xlib #defines translated manually, crudely, into ML
 *
 * J. Bradley Chen
 * INRIA
 *)
(*
(* #include <X11/X.h> *)
let X_PROTOCOL			= 11;;	(* current protocol version *)
let X_PROTOCOL_REVISION		= 0;;	(* current minor version *)

*)
#standard arith false;;
#fast arith false;;

(*****************************************************************
 * RESERVED RESOURCE AND CONSTANT DEFINITIONS
 *****************************************************************)
(* NOTE: None is renamed XNone *)

let XNone	     = Zero_Long	(* universal null resource/atom *)

and ParentRelative   = One_Long 	(* background pixmap in CreateWindow
				   	    and ChangeWindowAttributes *)

and CopyFromParent   = Zero_Long	(* border pixmap in CreateWindow
				   	   and ChangeWindowAttributes
					   special VisualID and special window
					   class passed to CreateWindow *)

and PointerWindow    = Zero_Long	(* destination window in SendEvent *)
and InputFocus	     = One_Long 	(* destination window in SendEvent *)

and PointerRoot	     = One_Long		(* focus window in SetInputFocus *)

and AnyPropertyType  = Zero_Long    (* special Atom, passed to GetProperty *)

and AnyKey	     = Zero_Long    (* special Key Code, passed to GrabKey *)

and AnyButton	     = Zero_Long    (* special Button Code, passed to GrabButton *)

and AllTemporary     = Zero_Long    (* special Resource ID passed to KillClient *)

and CurrentTime	     = Zero_Long    (* special Time *)

and NoSymbol	     = Zero_Long    (* special KeySym *)
;;
(*
(***************************************************************** 
 * EVENT DEFINITIONS 
 *****************************************************************)
*)
(* Input Event Masks. Used as event-mask window attribute and as arguments
   to Grab requests.  Not to be confused with event names.  *)
let NoEventMask			= Zero_Long
and KeyPressMask		= Bit_In_Long(0)
and KeyReleaseMask		= Bit_In_Long(1)
and ButtonPressMask		= Bit_In_Long(2)
and ButtonReleaseMask		= Bit_In_Long(3)
and EnterWindowMask		= Bit_In_Long(4)
and LeaveWindowMask		= Bit_In_Long(5)
and PointerMotionMask		= Bit_In_Long(6)
and PointerMotionHintMask	= Bit_In_Long(7)
and Button1MotionMask		= Bit_In_Long(8)
and Button2MotionMask		= Bit_In_Long(9)
and Button3MotionMask		= Bit_In_Long(10)
and Button4MotionMask		= Bit_In_Long(11)
and Button5MotionMask		= Bit_In_Long(12)
and ButtonMotionMask		= Bit_In_Long(13)
and KeymapStateMask		= Bit_In_Long(14)
and ExposureMask		= Bit_In_Long(15)
and VisibilityChangeMask	= Bit_In_Long(16)
and StructureNotifyMask		= Bit_In_Long(17)
and ResizeRedirectMask		= Bit_In_Long(18)
and SubstructureNotifyMask	= Bit_In_Long(19)
and SubstructureRedirectMask	= Bit_In_Long(20)
and FocusChangeMask		= Bit_In_Long(21)
and PropertyChangeMask		= Bit_In_Long(22)
and ColormapChangeMask		= Bit_In_Long(23)
and OwnerGrabButtonMask		= Bit_In_Long(24)
;;

(* Event names.  Used in "type" field in XEvent structures.  Not to be
confused with event masks above.  They start from 2 because 0 and 1
are reserved in the protocol for errors and replies. *)
let KeyPress		= C_Int_of_num(2)
and KeyRelease		= C_Int_of_num(3)
and ButtonPress		= C_Int_of_num(4)
and ButtonRelease	= C_Int_of_num(5)
and MotionNotify	= C_Int_of_num(6)
and EnterNotify		= C_Int_of_num(7)
and LeaveNotify		= C_Int_of_num(8)
and FocusIn		= C_Int_of_num(9)
and FocusOut		= C_Int_of_num(10)
and KeymapNotify	= C_Int_of_num(11)
and Expose		= C_Int_of_num(12)
and GraphicsExpose	= C_Int_of_num(13)
and NoExpose		= C_Int_of_num(14)
and VisibilityNotify	= C_Int_of_num(15)
and CreateNotify	= C_Int_of_num(16)
and DestroyNotify	= C_Int_of_num(17)
and UnmapNotify		= C_Int_of_num(18)
and MapNotify		= C_Int_of_num(19)
and MapRequest		= C_Int_of_num(20)
and ReparentNotify	= C_Int_of_num(21)
and ConfigureNotify	= C_Int_of_num(22)
and ConfigureRequest	= C_Int_of_num(23)
and GravityNotify	= C_Int_of_num(24)
and ResizeRequest	= C_Int_of_num(25)
and CirculateNotify	= C_Int_of_num(26)
and CirculateRequest	= C_Int_of_num(27)
and PropertyNotify	= C_Int_of_num(28)
and SelectionClear	= C_Int_of_num(29)
and SelectionRequest	= C_Int_of_num(30)
and SelectionNotify	= C_Int_of_num(31)
and ColormapNotify	= C_Int_of_num(32)
and ClientMessage	= C_Int_of_num(33)
and MappingNotify	= C_Int_of_num(34)
and LASTEvent		= C_Int_of_num(35)
(* LASTEvent must be bigger than any event # *)
;;

(* Key masks. Used as modifiers to GrabButton and GrabKey, results of
   QueryPointer, state in various key-, mouse-, and button-related events. *)

let ShiftMask		= Bit_In_Int(0)
and LockMask		= Bit_In_Int(1)
and ControlMask		= Bit_In_Int(2)
and Mod1Mask		= Bit_In_Int(3)
and Mod2Mask		= Bit_In_Int(4)
and Mod3Mask		= Bit_In_Int(5)
and Mod4Mask		= Bit_In_Int(6)
and Mod5Mask		= Bit_In_Int(7)
;;
(*
(* modifier names.  Used to build a SetModifierMapping request or
   to read a GetModifierMapping request.  These correspond to the
   masks defined above. *)
let ShiftMapIndex		= C_Int_of_num(0)
and LockMapIndex		= C_Int_of_num(1)
and ControlMapIndex		= C_Int_of_num(2)
and Mod1MapIndex		= C_Int_of_num(3)
and Mod2MapIndex		= C_Int_of_num(4)
and Mod3MapIndex		= C_Int_of_num(5)
and Mod4MapIndex		= C_Int_of_num(6)
and Mod5MapIndex		= C_Int_of_num(7)
;;

(* button masks.  Used in same manner as Key masks above. Not to be confused
   with button names below. *)
let Button1Mask		= Bit_In_Int(8)
and Button2Mask		= Bit_In_Int(9)
and Button3Mask		= Bit_In_Int(10)
and Button4Mask		= Bit_In_Int(11)
and Button5Mask		= Bit_In_Int(12)
and AnyModifier		= Bit_In_Int(15)  (* used in GrabButton, GrabKey *)
;;

(* button names. Used as arguments to GrabButton and as detail in ButtonPress
   and ButtonRelease events.  Not to be confused with button masks above.
   Note that 0 is already defined above as "AnyButton".  *)
let Button1			= C_Int_of_num(1)
and Button2			= C_Int_of_num(2)
and Button3			= C_Int_of_num(3)
and Button4			= C_Int_of_num(4)
and Button5			= C_Int_of_num(5)
;;

(* Notify modes *)
let NotifyNormal		= C_Int_of_num(0)
and NotifyGrab			= C_Int_of_num(1)
and NotifyUngrab		= C_Int_of_num(2)
and NotifyWhileGrabbed		= C_Int_of_num(3)
;;

(* for MotionNotify events *)
let NotifyHint			= C_Int_of_num(1)
;;

(* Notify detail *)
let NotifyAncestor		= C_Int_of_num(0)
and NotifyVirtual		= C_Int_of_num(1)
and NotifyInferior		= C_Int_of_num(2)
and NotifyNonlinear		= C_Int_of_num(3)
and NotifyNonlinearVirtual	= C_Int_of_num(4)
and NotifyPointer		= C_Int_of_num(5)
and NotifyPointerRoot		= C_Int_of_num(6)
and NotifyDetailNone		= C_Int_of_num(7)
;;

(* Visibility notify *)
let VisibilityUnobscured		= C_Int_of_num(0)
and VisibilityPartiallyObscured		= C_Int_of_num(1)
and VisibilityFullyObscured		= C_Int_of_num(2)
;;

(* Circulation request *)
let PlaceOnTop			= C_Int_of_num(0)
and PlaceOnBottom		= C_Int_of_num(1)
;;

(* protocol families *)
let FamilyInternet		= C_Int_of_num(0)
and FamilyDECnet		= C_Int_of_num(1)
and FamilyChaos			= C_Int_of_num(2)
;;

(* Property notification *)
let PropertyNewValue		= C_Int_of_num(0)
and PropertyDelete		= C_Int_of_num(1)
;;

(* Color Map notification *)
let ColormapUninstalled		= C_Int_of_num(0)
and ColormapInstalled		= C_Int_of_num(1)
;;

(* GrabPointer, GrabButton, GrabKeyboard, GrabKey Modes *)
let GrabModeSync		= C_Int_of_num(0)
and GrabModeAsync		= C_Int_of_num(1)
;;

(* GrabPointer, GrabKeyboard reply status *)
let GrabSuccess			= C_Int_of_num(0)
and AlreadyGrabbed		= C_Int_of_num(1)
and GrabInvalidTime		= C_Int_of_num(2)
and GrabNotViewable		= C_Int_of_num(3)
and GrabFrozen			= C_Int_of_num(4)
;;

(* AllowEvents modes *)
let AsyncPointer		= C_Int_of_num(0)
and SyncPointer			= C_Int_of_num(1)
and ReplayPointer		= C_Int_of_num(2)
and AsyncKeyboard		= C_Int_of_num(3)
and SyncKeyboard		= C_Int_of_num(4)
and ReplayKeyboard		= C_Int_of_num(5)
and AsyncBoth			= C_Int_of_num(6)
and SyncBoth			= C_Int_of_num(7)
;;

(* Used in SetInputFocus, GetInputFocus *)
let RevertToNone		= C_Int_of_Long(XNone)
and RevertToPointerRoot		= C_Int_of_Long(PointerRoot)
and RevertToParent		= C_Int_of_num(2)
;;

(*****************************************************************
 * ERROR CODES 
 *****************************************************************)
let Success	   = C_Int_of_num(0)	(* everything's okay *)
and BadRequest	   = C_Int_of_num(1)	(* bad request code *)
and BadValue	   = C_Int_of_num(2)	(* int parameter out of range *)
and BadWindow	   = C_Int_of_num(3)	(* parameter not a Window *)
and BadPixmap	   = C_Int_of_num(4)	(* parameter not a Pixmap *)
and BadAtom	   = C_Int_of_num(5)	(* parameter not an Atom *)
and BadCursor	   = C_Int_of_num(6)	(* parameter not a Cursor *)
and BadFont	   = C_Int_of_num(7)	(* parameter not a Font *)
and BadMatch	   = C_Int_of_num(8)	(* parameter mismatch *)
and BadDrawable	   = C_Int_of_num(9)	(* parameter not a Pixmap or Window *)
and BadAccess	   = C_Int_of_num(10)	(* depending on context:
					 - key/button already grabbed
					 - attempt to free an illegal 
					   cmap entry 
					- attempt to store into a read-only 
					   color map entry.
	 				- attempt to modify the access control
					   list from other than the local host.
					*)
and BadAlloc	  = C_Int_of_num(11)	(* insufficient resources *)
and BadColor	  = C_Int_of_num(12)	(* no such colormap *)
and BadGC	  = C_Int_of_num(13)	(* parameter not a GC *)
and BadIDChoice	  = C_Int_of_num(14)	(* choice not in range or in use *)
and BadName	  = C_Int_of_num(15)	(* font or color name doesn't exist *)
and BadLength	  = C_Int_of_num(16)	(* Request length incorrect *)
and BadImplementation = C_Int_of_num(17)	(* server is defective *)
;;

let FirstExtensionError	= C_Int_of_num(128)
and LastExtensionError	= C_Int_of_num(255)
;;

(*****************************************************************
 * WINDOW DEFINITIONS 
 *****************************************************************)

(* Window classes used by CreateWindow *)
(* Note that CopyFromParent is already defined as 0 above *)
let InputOutput		= C_Int_of_num(1)
and InputOnly		= C_Int_of_num(2)
;;

(* Window attributes for CreateWindow and ChangeWindowAttributes *)
*)
let CWBackPixmap		= Bit_In_Long(0)
and CWBackPixel			= Bit_In_Long(1)
and CWBorderPixmap		= Bit_In_Long(2)
and CWBorderPixel	        = Bit_In_Long(3)
and CWBitGravity		= Bit_In_Long(4)
and CWWinGravity		= Bit_In_Long(5)
and CWBackingStore      	= Bit_In_Long(6)
and CWBackingPlanes	        = Bit_In_Long(7)
and CWBackingPixel	        = Bit_In_Long(8)
and CWOverrideRedirect		= Bit_In_Long(9)
and CWSaveUnder			= Bit_In_Long(10)
and CWEventMask			= Bit_In_Long(11)
and CWDontPropagate	        = Bit_In_Long(12)
and CWColormap			= Bit_In_Long(13)
and CWCursor	       		= Bit_In_Long(14)
;;

(* ConfigureWindow structure *)
let CWX				= Bit_In_Int(0)
and CWY				= Bit_In_Int(1)
and CWWidth			= Bit_In_Int(2)
and CWHeight			= Bit_In_Int(3)
and CWBorderWidth		= Bit_In_Int(4)
and CWSibling			= Bit_In_Int(5)
and CWStackMode			= Bit_In_Int(6)
;;
(*
(* Bit Gravity *)
let ForgetGravity		= C_Int_of_num(0)
and NorthWestGravity		= C_Int_of_num(1)
and NorthGravity		= C_Int_of_num(2)
and NorthEastGravity		= C_Int_of_num(3)
and WestGravity			= C_Int_of_num(4)
and CenterGravity		= C_Int_of_num(5)
and EastGravity			= C_Int_of_num(6)
and SouthWestGravity		= C_Int_of_num(7)
and SouthGravity		= C_Int_of_num(8)
and SouthEastGravity		= C_Int_of_num(9)
and StaticGravity		= C_Int_of_num(10)
;;

(* Window gravity + bit gravity above *)
let UnmapGravity		= C_Int_of_num(0);;
*)
(* Used in CreateWindow for backing-store hint *)
let NotUseful               = C_Int_of_num(0)
and WhenMapped              = C_Int_of_num(1)
and Always                  = C_Int_of_num(2)
;;
(*
(* Used in GetWindowAttributes reply *)
let IsUnmapped			= C_Int_of_num(0)
and IsUnviewable		= C_Int_of_num(1)
and IsViewable			= C_Int_of_num(2)
;;

(* Used in ChangeSaveSet *)
let SetModeInsert           = C_Int_of_num(0)
and SetModeDelete           = C_Int_of_num(1)
;;

(* Used in ChangeCloseDownMode *)
let DestroyAll              = C_Int_of_num(0)
and RetainPermanent         = C_Int_of_num(1)
and RetainTemporary         = C_Int_of_num(2)
;;
*)
(* Window stacking method (in configureWindow) *)
let Above                   = C_Int_of_num(0)
and Below                   = C_Int_of_num(1)
and TopIf                   = C_Int_of_num(2)
and BottomIf                = C_Int_of_num(3)
and Opposite                = C_Int_of_num(4)
;;
(*
(* Circulation direction *)
let RaiseLowest             = C_Int_of_num(0)
and LowerHighest            = C_Int_of_num(1)
;;

(* Property modes *)
let PropModeReplace         = C_Int_of_num(0)
and PropModePrepend         = C_Int_of_num(1)
and PropModeAppend          = C_Int_of_num(2)
;;

(*****************************************************************
 * GRAPHICS DEFINITIONS
 *****************************************************************)
*)
(* graphics functions, as in GC.alu *)
let GXclear		= C_Int_of_num(0)	(* 0 *)
and GXand		= C_Int_of_num(1)	(* src AND dst *)
and GXandReverse	= C_Int_of_num(2)	(* src AND NOT dst *)
and GXcopy		= C_Int_of_num(3)	(* src *)
and GXandInverted	= C_Int_of_num(4)	(* NOT src AND dst *)
and GXnoop		= C_Int_of_num(5)	(* dst *)
and GXxor		= C_Int_of_num(6)	(* src XOR dst *)
and GXor		= C_Int_of_num(7)	(* src OR dst *)
and GXnor		= C_Int_of_num(8)	(* NOT src AND NOT dst *)
and GXequiv		= C_Int_of_num(9)	(* NOT src XOR dst *)
and GXinvert		= C_Int_of_num(10)	(* NOT dst *)
and GXorReverse		= C_Int_of_num(11)	(* src OR NOT dst *)
and GXcopyInverted	= C_Int_of_num(12)	(* NOT src *)
and GXorInverted	= C_Int_of_num(13)	(* NOT src OR dst *)
and GXnand		= C_Int_of_num(14)	(* NOT src OR NOT dst *)
and GXset		= C_Int_of_num(15)	(* 1 *)
;;
(*
(* LineStyle *)
let LineSolid			= C_Int_of_num(0)
and LineOnOffDash		= C_Int_of_num(1)
and LineDoubleDash		= C_Int_of_num(2)
;;
*)
(* capStyle *)
let CapNotLast			= C_Int_of_num(0)
and CapButt			= C_Int_of_num(1)
and CapRound			= C_Int_of_num(2)
and CapProjecting		= C_Int_of_num(3)
;;
(*
(* joinStyle *)
let JoinMiter			= C_Int_of_num(0)
and JoinRound			= C_Int_of_num(1)
and JoinBevel			= C_Int_of_num(2)
;;
*)
(* fillStyle *)
let FillSolid			= C_Int_of_num(0)
and FillTiled			= C_Int_of_num(1)
and FillStippled		= C_Int_of_num(2)
and FillOpaqueStippled		= C_Int_of_num(3)
;;
(*
(* fillRule *)
let EvenOddRule			= C_Int_of_num(0)
and WindingRule			= C_Int_of_num(1)
;;
*)
(* subwindow mode *)
let ClipByChildren		= C_Int_of_num(0)
and IncludeInferiors		= C_Int_of_num(1)
;;
(*
(* SetClipRectangles ordering *)
let Unsorted			= C_Int_of_num(0)
and YSorted			= C_Int_of_num(1)
and YXSorted			= C_Int_of_num(2)
and YXBanded			= C_Int_of_num(3)
;;
*)
(* CoordinateMode for drawing routines *)
let CoordModeOrigin	= C_Int_of_num(0)  (* relative to the origin *)
and CoordModePrevious   = C_Int_of_num(1)  (* relative to previous point *)
;;

(* Polygon shapes *)
let Complex	= C_Int_of_num(0)    (* paths may intersect *)
and Nonconvex	= C_Int_of_num(1)    (* no paths intersect, but not convex *)
and Convex	= C_Int_of_num(2)    (* wholly convex *)
;;
(*
(* Arc modes for PolyFillArc *)
let ArcChord	= C_Int_of_num(0)	(* join endpoints of arc *)
and ArcPieSlice	= C_Int_of_num(1)	(* join endpoints to center of arc *)
;;
*)
(* GC components: masks used in CreateGC, CopyGC, ChangeGC, OR'ed into
   GC.stateChanges *)
let GCFunction              = Bit_In_Long(0)
and GCPlaneMask             = Bit_In_Long(1)
and GCForeground            = Bit_In_Long(2)
and GCBackground            = Bit_In_Long(3)
and GCLineWidth             = Bit_In_Long(4)
and GCLineStyle             = Bit_In_Long(5)
and GCCapStyle              = Bit_In_Long(6)
and GCJoinStyle		    = Bit_In_Long(7)
and GCFillStyle		    = Bit_In_Long(8)
and GCFillRule		    = Bit_In_Long(9) 
and GCTile		    = Bit_In_Long(10)
and GCStipple		    = Bit_In_Long(11)
and GCTileStipXOrigin	    = Bit_In_Long(12)
and GCTileStipYOrigin	    = Bit_In_Long(13)
and GCFont 		    = Bit_In_Long(14)
and GCSubwindowMode	    = Bit_In_Long(15)
and GCGraphicsExposures     = Bit_In_Long(16)
and GCClipXOrigin	    = Bit_In_Long(17)
and GCClipYOrigin	    = Bit_In_Long(18)
and GCClipMask		    = Bit_In_Long(19)
and GCDashOffset	    = Bit_In_Long(20)
and GCDashList		    = Bit_In_Long(21)
and GCArcMode		    = Bit_In_Long(22)
;;
(*
let GCLastBit		= 22;;

(*****************************************************************
 * FONTS 
 *****************************************************************)

(* used in QueryFont -- draw direction *)
let FontLeftToRight		= C_Int_of_num(0)
and FontRightToLeft		= C_Int_of_num(1)
and FontChange			= C_Int_of_num(255)
;;

(*****************************************************************
 *  IMAGING 
 *****************************************************************)
*)
(* ImageFormat -- PutImage, GetImage *)
let XYBitmap		= C_Int_of_num(0)	(* depth 1, XYFormat *)
and XYPixmap		= C_Int_of_num(1)	(* depth == drawable depth *)
and ZPixmap		= C_Int_of_num(2)	(* depth == drawable depth *)
;;
(*

(*****************************************************************
 *  COLOR MAP STUFF 
 *****************************************************************)

(* For CreateColormap *)
let AllocNone	= C_Int_of_num(0)	(* create map with no entries *)
and AllocAll	= C_Int_of_num(1)	(* allocate entire map writeable *)
;;
*)
(* Flags used in StoreNamedColor, StoreColors *)
let DoRed			= C_Char(#1)
and DoGreen			= C_Char(#2)
and DoBlue			= C_Char(#4)
and DoRed_DoGreen_DoBlue        = C_Char(#7)
;;
(*
(*****************************************************************
 * CURSOR STUFF
 *****************************************************************)

(* QueryBestSize Class *)
let CursorShape	 = C_Int_of_num(0)    (* largest size that can be displayed *)
and TileShape	 = C_Int_of_num(1)	(* size tiled fastest *)
and StippleShape = C_Int_of_num(2)	(* size stippled fastest *)
;;

(***************************************************************** 
 * KEYBOARD/POINTER STUFF
 *****************************************************************)
let AutoRepeatModeOff	= C_Int_of_num(0)
and AutoRepeatModeOn	= C_Int_of_num(1)
and AutoRepeatModeDefault	= C_Int_of_num(2)
;;

let LedModeOff		= C_Int_of_num(0)
and LedModeOn		= C_Int_of_num(1)
;;

(* masks for ChangeKeyboardControl *)
let KBKeyClickPercent		= Bit_In_Long(0)
and KBBellPercent		= Bit_In_Long(1)
and KBBellPitch			= Bit_In_Long(2)
and KBBellDuration		= Bit_In_Long(3)
and KBLed			= Bit_In_Long(4)
and KBLedMode			= Bit_In_Long(5)
and KBKey			= Bit_In_Long(6)
and KBAutoRepeatMode		= Bit_In_Long(7)
;;

let MappingSuccess     	= C_Int_of_num(0)
and MappingBusy        	= C_Int_of_num(1)
and MappingFailed	= C_Int_of_num(2)
;;

let MappingModifier		= C_Int_of_num(0)
and MappingKeyboard		= C_Int_of_num(1)
and MappingPointer		= C_Int_of_num(2)
;;

(*****************************************************************
 * SCREEN SAVER STUFF 
 *****************************************************************)
let DontPreferBlanking		= C_Int_of_num(0)
and PreferBlanking		= C_Int_of_num(1)
and DefaultBlanking		= C_Int_of_num(2)
;;

let DisableScreenSaver		= C_Int_of_num(0)
and DisableScreenInterval	= C_Int_of_num(0)
;;

let DontAllowExposures		= C_Int_of_num(0)
and AllowExposures		= C_Int_of_num(1)
and DefaultExposures		= C_Int_of_num(2)
;;

(* for ForceScreenSaver *)
let ScreenSaverReset		 = C_Int_of_num(0)
and ScreenSaverActive		 = C_Int_of_num(1)
;;

(*****************************************************************
 * HOSTS AND CONNECTIONS
 *****************************************************************)

(* for ChangeHosts *)
let HostInsert		= C_Int_of_num(0)
and HostDelete		= C_Int_of_num(1)
;;

(* for ChangeAccessControl *)
let EnableAccess		= C_Int_of_num(1)      
and DisableAccess		= C_Int_of_num(0)
;;

(* Display classes  used in opening the connection 
 * Note that the statically allocated ones are even numbered and the
 * dynamically changeable ones are odd numbered *)
let StaticGray		= C_Int_of_num(0)
and GrayScale		= C_Int_of_num(1)
and StaticColor		= C_Int_of_num(2)
and PseudoColor		= C_Int_of_num(3)
and TrueColor		= C_Int_of_num(4)
and DirectColor		= C_Int_of_num(5)
;;
*)
(* Byte order  used in imageByteOrder and bitmapBitOrder *)
let LSBFirst		= C_Int_of_num(0)
and MSBFirst		= C_Int_of_num(1)
;;
(*
(* #endif X_H *)

let QueuedAlready 	= 0
and QueuedAfterReading	= 1
and QueuedAfterFlush	= 2
;;

(* let AllPlanes 		(~0) *)

(* #endif (* _XLIB_H_ *) *)
*)
(* Xatom.h *)

let XA_PRIMARY				= Atom_of_num(1)
and XA_SECONDARY			= Atom_of_num(2)
and XA_ARC				= Atom_of_num(3)
and XA_ATOM				= Atom_of_num(4)
and XA_BITMAP				= Atom_of_num(5)
and XA_CARDINAL				= Atom_of_num(6)
and XA_COLORMAP				= Atom_of_num(7)
and XA_CURSOR				= Atom_of_num(8)
and XA_CUT_BUFFER0			= Atom_of_num(9)
and XA_CUT_BUFFER1			= Atom_of_num(10)
and XA_CUT_BUFFER2			= Atom_of_num(11)
and XA_CUT_BUFFER3			= Atom_of_num(12)
and XA_CUT_BUFFER4			= Atom_of_num(13)
and XA_CUT_BUFFER5			= Atom_of_num(14)
and XA_CUT_BUFFER6			= Atom_of_num(15)
and XA_CUT_BUFFER7			= Atom_of_num(16)
and XA_DRAWABLE				= Atom_of_num(17)
and XA_FONT				= Atom_of_num(18)
and XA_INTEGER				= Atom_of_num(19)
and XA_PIXMAP				= Atom_of_num(20)
and XA_POINT				= Atom_of_num(21)
and XA_RECTANGLE			= Atom_of_num(22)
and XA_RESOURCE_MANAGER			= Atom_of_num(23)
and XA_RGB_COLOR_MAP			= Atom_of_num(24)
and XA_RGB_BEST_MAP			= Atom_of_num(25)
and XA_RGB_BLUE_MAP			= Atom_of_num(26)
and XA_RGB_DEFAULT_MAP			= Atom_of_num(27)
and XA_RGB_GRAY_MAP			= Atom_of_num(28)
and XA_RGB_GREEN_MAP			= Atom_of_num(29)
and XA_RGB_RED_MAP			= Atom_of_num(30)
and XA_STRING				= Atom_of_num(31)
and XA_VISUALID				= Atom_of_num(32)
and XA_WINDOW				= Atom_of_num(33)
and XA_WM_COMMAND			= Atom_of_num(34)
and XA_WM_HINTS				= Atom_of_num(35)
and XA_WM_CLIENT_MACHINE		= Atom_of_num(36)
and XA_WM_ICON_NAME			= Atom_of_num(37)
and XA_WM_ICON_SIZE			= Atom_of_num(38)
and XA_WM_NAME				= Atom_of_num(39)
and XA_WM_NORMAL_HINTS			= Atom_of_num(40)
and XA_WM_SIZE_HINTS			= Atom_of_num(41)
and XA_WM_ZOOM_HINTS			= Atom_of_num(42)
and XA_MIN_SPACE			= Atom_of_num(43)
and XA_NORM_SPACE			= Atom_of_num(44)
and XA_MAX_SPACE			= Atom_of_num(45)
and XA_END_SPACE			= Atom_of_num(46)
and XA_SUPERSCRIPT_X			= Atom_of_num(47)
and XA_SUPERSCRIPT_Y			= Atom_of_num(48)
and XA_SUBSCRIPT_X			= Atom_of_num(49)
and XA_SUBSCRIPT_Y			= Atom_of_num(50)
and XA_UNDERLINE_POSITION		= Atom_of_num(51)
and XA_UNDERLINE_THICKNESS		= Atom_of_num(52)
and XA_STRIKEOUT_ASCENT			= Atom_of_num(53)
and XA_STRIKEOUT_DESCENT		= Atom_of_num(54)
and XA_ITALIC_ANGLE			= Atom_of_num(55)
and XA_X_HEIGHT				= Atom_of_num(56)
and XA_QUAD_WIDTH			= Atom_of_num(57)
and XA_WEIGHT				= Atom_of_num(58)
and XA_POINT_SIZE			= Atom_of_num(59)
and XA_RESOLUTION			= Atom_of_num(60)
and XA_COPYRIGHT			= Atom_of_num(61)
and XA_NOTICE				= Atom_of_num(62)
and XA_FONT_NAME			= Atom_of_num(63)
and XA_FAMILY_NAME			= Atom_of_num(64)
and XA_FULL_NAME			= Atom_of_num(65)
and XA_CAP_HEIGHT			= Atom_of_num(66)
and XA_WM_CLASS				= Atom_of_num(67)
and XA_WM_TRANSIENT_FOR			= Atom_of_num(68)

and XA_LAST_PREDEFINED			= Atom_of_num(68)
;;
(*

(* Xutil.h *)

(* 
 * Bitmask returned by XParseGeometry().  Each bit tells if the corresponding
 * value (x, y, width, height) was found in the parsed string.
 *)
let NoValue		= Zero_Long
and XValue  		= C_Long_of_num(1)
and YValue		= C_Long_of_num(2)
and WidthValue  	= C_Long_of_num(4)
and HeightValue  	= C_Long_of_num(8)
and AllValues 		= C_Long_of_num(15) (* 0x000F *) 
and XNegative 		= C_Long_of_num(16) (* 0x0010 *)
and YNegative 		= C_Long_of_num(32) (* 0x0020 *)
;;

(*
 * The next block of definitions are for window manager properties that
 * clients and applications use for communication.
 *)
*)
(* flags argument in size hints *)
let USPosition	= C_Long_of_num(1)	 (* user specified x, y *)
and USSize	= C_Long_of_num(2) (* user specified width, height *)
and PPosition	= C_Long_of_num(4) (* program specified position *)
and PSize	= C_Long_of_num(8) (* program specified size *)
and PMinSize	= C_Long_of_num(16) (* program specified minimum size *)
and PMaxSize	= C_Long_of_num(32) (* program specified maximum size *)
and PResizeInc	= C_Long_of_num(64) (* program specified resize increments *)
and PAspect	= C_Long_of_num(128) (* prog.spec. min and max aspect ratios *)
and PBaseSize	= C_Long_of_num(256) (* prog.spec. base for incrementing *)
and PWinGravity	= C_Long_of_num(512) (* program specified window gravity *)
(* obsolete *)
and PAllHints   = C_Long_of_num(1023)
;; (* PPosition|PSize|PMinSize|PMaxSize|PResizeInc|PAspect *)

(* definition for flags of XWMHints *)

let InputHint 		= C_Long_of_num(1)
and StateHint 		= C_Long_of_num(2)
and IconPixmapHint	= C_Long_of_num(4)
and IconWindowHint	= C_Long_of_num(8)
and IconPositionHint 	= C_Long_of_num(16)
and IconMaskHint	= C_Long_of_num(32)
and WindowGroupHint	= C_Long_of_num(64)
and AllHints 		= C_Long_of_num(127)
(* InputHint|StateHint|IconPixmapHint|IconWindowHint| 
IconPositionHint|IconMaskHint|WindowGroupHint *)
;;
(*

(* definitions for initial window state *)
let WithdrawnState = C_Int_of_num(0)	(* for windows that are not mapped *)
and NormalState    = C_Int_of_num(1)	(* most want to start this way *)
and IconicState    = C_Int_of_num(3)	(* wants to start as an icon *)
(* Obsolete states no longer defined by ICCCM *)
and DontCareState = C_Int_of_num(0)	(* don't know or care *)
and ZoomState     = C_Int_of_num(2)	(* application wants to start zoomed *)
and InactiveState = C_Int_of_num(4)
;;

(* Return values from XRectInRegion() *)
let RectangleOut  = C_Int_of_num(0)
and RectangleIn   = C_Int_of_num(1)
and RectanglePart = C_Int_of_num(2)
;;

let VisualNoMask		= C_Long_of_num(0)
and VisualIDMask 		= C_Long_of_num(1)
and VisualScreenMask		= C_Long_of_num(2)
and VisualDepthMask		= C_Long_of_num(4)
and VisualClassMask		= C_Long_of_num(8)
and VisualRedMaskMask		= C_Long_of_num(16)
and VisualGreenMaskMask		= C_Long_of_num(32)
and VisualBlueMaskMask		= C_Long_of_num(64)
and VisualColormapSizeMask	= C_Long_of_num(128)
and VisualBitsPerRGBMask	= C_Long_of_num(256)
and VisualAllMask		= C_Long_of_num(511)
;;

let ReleaseByFreeingColormap    = C_Long_of_num(1) (* for killid field above *)
;;

(*
 * return codes for XReadBitmapFile and XWriteBitmapFile
 *)
let BitmapSuccess	= C_Int_of_num(0)
and BitmapOpenFailed 	= C_Int_of_num(1)
and BitmapFileInvalid 	= C_Int_of_num(2)
and BitmapNoMemory	= C_Int_of_num(3)
;;

(*
 * Declare the routines that don't return int.
 *)
(****************************************************************
 *
 * Context Management
 *
 ****************************************************************)


(* Associative lookup table return codes *)
let XCSUCCESS 	= C_Int_of_num(0)	(* No error. *)
and XCNOMEM   	= C_Int_of_num(1)	(* Out of memory *)
and XCNOENT   	= C_Int_of_num(2)	(* No entry in table *)
;;

(* ???
and XUniqueContext()       ((XContext) XrmUniqueQuark())
and XStringToContext(string)   ((XContext) XrmStringToQuark(string))
*)

(*
 * Keysym macros, used on Keysyms to test for classes of symbols
 *)
(*
and IsKeypadKey(keysym) \
  (((unsigned)(keysym) >= XK_KP_Space) && ((unsigned)(keysym) <= XK_KP_Equal))

and IsCursorKey(keysym) \
  (((unsigned)(keysym) >= XK_Home)     && ((unsigned)(keysym) <  XK_Select))

and IsPFKey(keysym) \
  (((unsigned)(keysym) >= XK_KP_F1)     && ((unsigned)(keysym) <= XK_KP_F4))

and IsFunctionKey(keysym) \
  (((unsigned)(keysym) >= XK_F1)       && ((unsigned)(keysym) <= XK_F35))

and IsMiscFunctionKey(keysym) \
  (((unsigned)(keysym) >= XK_Select)   && ((unsigned)(keysym) <  XK_KP_Space))

and IsModifierKey(keysym) \
  (((unsigned)(keysym) >= XK_Shift_L)  && ((unsigned)(keysym) <= XK_Hyper_R))
*)
*)
();;
