;; Extracts yacc tables and actions form yacc output.
;;

(defvar beg)
(defvar Name (nth 5 command-line-args))
(defvar CWD (nth 4 command-line-args))
(defvar yacc-tables (concat CWD "y.tab.c"))

; For debugging purposes
;(print (nth 5 command-line-args))
;(sit-for 1)
;(print (nth 4 command-line-args))
;(sit-for 1)
;(print (nth 3 command-line-args))
;(sit-for 1)

(defvar the-buffer (current-buffer))
(defvar work-buffer (generate-new-buffer "work"))

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents yacc-tables)

(goto-char (point-min))
(setq beg (point))
(re-search-forward "^# *line")
(forward-line 1)
(delete-region beg (point))

(goto-char (point-min))
(re-search-forward "^(\\* Caml part \\*)$" (point-max))
(forward-line 0)
(delete-region (point) (point-max))

(goto-char (point-min))
(replace-regexp
   "# *define *\\([0-9A-Za-z_]*\\)\\(.*\\)$"
   "let UnIqUe_NaMe_\\1 =\\2;;" nil)

(goto-char (point-min))
(insert "
directive open_env \""
Name
"\";;

(* BEGINNING OF LEXICALS *)

let syntax_name = \""
Name
"\";;
")

(set-buffer the-buffer)
(erase-buffer)
(insert-buffer work-buffer)

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents yacc-tables)

(goto-char (point-min))
(search-forward "yytabelem yyexca")
(forward-line -1)
(delete-region (point-min) (point))

(goto-char (point-min))
(re-search-forward "typedef struct")
(forward-line 0)
(delete-region (point) (point-max))

(goto-char (point-min))
(replace-string "yytabelem" "let ")
(goto-char (point-min))
(replace-regexp "\\[\\].*" " = [|")
(goto-char (point-min))
(replace-string "," ";")
(goto-char (point-min))
(replace-regexp "\\(default_ol_grammar:=(\"[^;]*\\);\\(.*\\)" "\\1,\\2")
(goto-char (point-min))
(replace-string "};" "|];;")
(goto-char (point-min))
(replace-regexp "# *define *\\([A-Z]*\\)\\(.*\\)$" "let \\1 =\\2;;")

(goto-char (point-min))
(re-search-forward "let  yychk =")
(beginning-of-line)
(insert "

modify_vect
 (function n ->
  unchecked_coercion (
   quo_int
    (sub_int (unchecked_coercion n,(mod_int (unchecked_coercion n,#2))),
     #2)))
 yyr2;;

")

(goto-char (point-max))
(search-backward "let YYNPROD = ")
(forward-line -2)
(re-search-forward ";$")
(delete-backward-char 1)
(goto-char (point-min))
(insert "
(* BEGINNING OF TABLES *)
")

(goto-char (point-max))
(insert "
(* END OF TABLES *)
")

(set-buffer the-buffer)
(goto-char (point-max))
(insert-buffer work-buffer)

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents yacc-tables)

(goto-char (point-min))
(search-forward "switch( yytmp )")
(forward-line 1)
(delete-region (point-min) (point))

(goto-char (point-min))
(kill-line 1)

(goto-char (point-min))
(search-forward "goto yystack;")
(forward-line -1)
(delete-region (point) (point-max))

(goto-char (point-min))
(replace-regexp
    "^case \\(.*\\):"
    "vect_assign(UnIqUe_NaMe_yyact_vect, \\1, (fun () -> ")
(goto-char (point-min))
(replace-regexp "^# line\\(.*\\)$" "(* action line\\1 *)")
(goto-char (point-min))
(replace-regexp "^{" "Repr (")
(goto-char (point-min))
(replace-string "} break;" ")));;")
(goto-char (point-min))
(replace-regexp "yypvt\\[-\\([0-9]*\\)\\]" "(peek_val \\1)")

(goto-char (point-min))
(insert "
let UnIqUe_NaMe_yytabs =
     (yyexca,yyact,yypact,yypgo,yyr1,yyr2,yychk,yydef);;

(* BEGINNING OF ACTIONS *)

let UnIqUe_NaMe_yyact_vect = vector (YYNPROD+1) of (fun () -> !yy_val);;
")
(goto-char (point-max))
(insert "
let UnIqUe_NaMe_yyactions n = vect_item(UnIqUe_NaMe_yyact_vect, n) ();;

(* END OF ACTIONS *)

let UnIqUe_NaMe_lsyntax =
             (UnIqUe_NaMe_strings,UnIqUe_NaMe_double,
	     (UnIqUe_NaMe_NUM,UnIqUe_NaMe_INT,UnIqUe_NaMe_FLOAT,
              UnIqUe_NaMe_IDENT,UnIqUe_NaMe_BOOL,UnIqUe_NaMe_STRING,
              UnIqUe_NaMe_INFIX,UnIqUe_NaMe_CHAR,UnIqUe_NaMe_EOF,
              UnIqUe_NaMe_BIGINT,UnIqUe_NaMe_RATIO,UnIqUe_NaMe_DYN),
	     (UnIqUe_NaMe_strdelim,UnIqUe_NaMe_cmndelim),
	     UnIqUe_NaMe_sub_syntaxes)
;;

let UnIqUe_NaMe_psyntax =
  (UnIqUe_NaMe_yyactions,UnIqUe_NaMe_yytabs,YYLAST);;

let UnIqUe_NaMe_syntax =
    CAML_system_make_Syntax
     (\"UnIqUe_NaMe\",UnIqUe_NaMe_syntax_flag,
        UnIqUe_NaMe_lsyntax,UnIqUe_NaMe_psyntax);;
	
(* syntax_flag = (yy_)lex; syntax_type = syntax/value *)

add_syntax (make_parser UnIqUe_NaMe_syntax_type  UnIqUe_NaMe_syntax);()
")

(set-buffer the-buffer)
(goto-char (point-max))
(insert-buffer work-buffer)

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents yacc-tables)

;(print "4th phase")
(goto-char (point-min))
(re-search-forward "^(\\* Caml part \\*)$")
(forward-line -1)
(delete-region (point-min) (point))

(goto-char (point-min))
(search-forward "int yyexca")
(forward-line 0)
(delete-region (point) (point-max))

(set-buffer the-buffer)
(goto-char (point-max))
(insert-buffer work-buffer)
(goto-char (point-min))
(replace-string "UnIqUe_NaMe" Name)

;(print "Saving...")
;(print  (concat (concat CWD Name) "_mly.ml"))
;(sit-for 10)
(write-region (point-min) (point-max)
              (concat (concat CWD Name) "_mly.ml") nil 'nomsg)
(erase-buffer)
(kill-emacs)
