/* $Id: ddr_ext.c,v 7.1 91/05/28 20:50:28 ddr Exp $
 *
 * extensions C et modifs a l'interface X
 *
 * $Log:	ddr_ext.c,v $
 * Revision 7.1  91/05/28  20:50:28  ddr
 * - distrib
 * 
 * Revision 6.2  91/05/27  11:01:12  ddr
 * - sockets
 * 
 * Revision 6.1  91/04/22  13:58:08  ddr
 * - distrib
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <errno.h>
extern int errno;

#ifndef FD_ZERO

#define NFDBITS 32
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))

#endif FD_ZERO

/*
 * fselect
 */

#if 0
void ML_free_fd_set(fds)
fd_set *fds;
{
	free(fds);
}
#endif

void ML_FD_ZERO(fds)
fd_set *fds;
{
	FD_ZERO(fds);
}

void ML_FD_SET(fd, fds)
int fd;
fd_set *fds;
{
	FD_SET(fd, fds);
}

int ML_FD_ISSET(fd, fds)
int fd;
fd_set *fds;
{
	return FD_ISSET(fd, fds);
}

int ML_fselect(nfds, readfds, msec)
int nfds;
fd_set *readfds;
long msec;
{
	struct timeval timeout;

	timeout.tv_sec = msec / 1000;
	timeout.tv_usec = msec % 1000 * 1000;
	return select(nfds, readfds, 0, 0, (msec < 0) ? 0 : &timeout);
}

/*
 * patch de XPoint
 */

XPoint *patch_ML_alloc_XPoint(len)
int len;
{
	return (XPoint *) malloc(len*sizeof(XPoint));
}

void patch_ML_set_XPoint_x(x, points, i)
short x;
XPoint *points;
int i;
{
	points[i].x = x;
}

void patch_ML_set_XPoint_y(y, points, i)
short y;
XPoint *points;
int i;
{
	points[i].y = y;
}

short patch_ML_XPoint_x(points, i)
XPoint *points;
int i;
{
	return points[i].x;
}

short patch_ML_XPoint_y(points, i)
XPoint *points;
int i;
{
	return points[i].y;
}

/*
 * sockets
 */

static failwith_errno(s, err)
char *s;
int err;
{
	static char b[50];
	sprintf(b, "%s; errno = %d", s, err);
	failwith(b);
}

static sig_pipe()
{
	failwith("broken pipe");
}

int ML_socket_server(port)
int port;
{
	int s, t, on = 1, err, len;
	struct sockaddr_in addr;

	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0) failwith_errno("socket_server", errno);
	signal(SIGPIPE, sig_pipe);

	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = port;
	bzero((char *) addr.sin_zero, sizeof addr.sin_zero);
	if (bind(s, (struct sockaddr *) &addr, sizeof addr) < 0) {
		err = errno; close(s);
		failwith_errno("socket_server bind", err);
	}
	(void) setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &on, sizeof on);
	(void) setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, &on, sizeof on);
	if (listen(s, 1) < 0) {
		err = errno; close(s);
		failwith_errno("socket_server listen", err);
	}

	len = sizeof addr;
	t = accept(s, (struct sockaddr *) &addr, &len);
	if (t < 0) {
		err = errno; close(s);
		failwith_errno("socket_server accept", err);
	}
	close(s);
	return t;
}

int ML_socket_client(host, port)
char *host;
int port;
{
	int s, err;
	struct sockaddr_in addr;
	struct hostent *hp;

	addr.sin_addr.s_addr = inet_addr(host);
	if (addr.sin_addr.s_addr == -1) {
		hp = gethostbyname(host);
		if (!hp) failwith("socket_client: unknown host");
		bcopy(hp->h_addr, (caddr_t) &addr.sin_addr,
		      hp->h_length);
	}
	addr.sin_family = AF_INET;
	addr.sin_port = port;
	bzero((char *) addr.sin_zero, sizeof addr.sin_zero);
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0) failwith_errno("socket_client", errno);
	signal(SIGPIPE, sig_pipe);
	if (connect(s, (struct sockaddr *) &addr, sizeof addr) < 0) {
		err = errno; close(s);
		failwith_errno("socket_client connect", err);
	}

	return s;
}
