(defvar #:sys-package:colon 'ld68k)

(unless (boundp ':mlconstants) (defvar :mlconstants ()))

(de #:loader:new_error (f a)
    ; erreur dans la fonction f arguments defectueux a
    (with ((outchan ()))
	  (terpri)
          (setq f (selectq f
               ("MLEXC" "undefined exception")
               ("MLVAL" "undefined value")
               ("MLSYS" "undefined system value")
               (t f)))
	  (print "**** "
		 (get-message '#:loader:ERRLOADER)
		 f
		 ": "
                 a
       (exit #:system:error-tag))

))

(de get_global_value (ident) ())
(de get_global_sysvalue (ident) ())
(de get_global_exc (ident) ())
(de get_global_sysexc (ident) ())
(de get_global_type (ident) ())
(de get_global_systype (ident) ())

(de mlval (arg)
           ; la valeur ml ordinaire.
	    (let ((:val (get_global_value arg)))
		     (if :val
			 (cons 'quote :val)
			 (#:loader:new_error "MLVAL" arg))))



(de mlsys (arg)    
 ; la valeur ml du systeme
 (let ((:val (get_global_sysvalue arg)))
		     (if :val 
			 (cons 'quote :val)
			 (#:loader:new_error "MLSYS" arg))))
		


(de mlexc (arg)
	  ; CAML exception
          ; (mlexc <string>)
	   (let ((:val (get_global_exc arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "MLEXC" arg))))



(de sysexc (arg)
	  ; CAML system exception
          ; (sysexc <string>)
	   (let ((:val (get_global_sysexc arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "SYSEXC" arg))))


(de mltyp (arg)
          ; CAML type constructor
          ; (mltyp <string>)
	  (let ((:val (get_global_type arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "MLTYP" arg))))

(de systyp (arg)
          ; CAML type constructor
          ; (mltyp <string>)
	  (let ((:val (get_global_systype arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "SYSTYP" arg))))

(de mlquote (arg1 arg2)
           ; (mlquote lab constant)
           `(quote ,(cdr (or (assq arg1 :mlconstants)
                          (car (setq :mlconstants
                                     (acons arg1 arg2
                                            :mlconstants)))))))

(de mlentry () 
	      ; MLENTRY   = (fentry mleval subr0) (entry mleval subr0)
                ; MODIF : pour enlever les cons-llitt en trop
                (setq #:ld:ml-local-cons-llitt :local-cons-llitt)
                (setq #:ld:ml-cons-llitt #:ld:cons-llitt)
                (#:loader:align)
                (remprop 'mleval '#:system:loaded-from-file)
                (remprop 'mleval '#:llcp:ftype)
                (remprop 'mleval '#:llcp:fval)
                (setfn 'mleval 'subr0 #:loader:pccurrent)
                (newl :llabels (cons 'mleval (copylist #:loader:pccurrent)))
                (setq :fntname 'mleval)
                (putprop 'mleval (copylist #:loader:pccurrent) ':fval)
                (newl :entry-list '(mleval subr0 ())))

(de #:system:set-ccode (addr)
    (#:system:ccode addr)
)
