(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* caml_gram The grammar of CAML itself                                  *)
(*           Michel Mauny (translation from old Yacc interface)          *)
(*           Ascander Suarez                                             *)
(*           Pierre Weis                                                 *)

#system module caml_gram;;

let mk_type_binding (x,y) z = x,y,z;;

let MLtypes_of_vars = map (fun s -> MLvartyp s);;

let ill_typed_macro d ty =
    do_on_error_out_channel(
        fun ty ->
           print_string "macro has type: ";
           print_type (fst (un_dynamic d)); print_newline()) ty;
    raise parse ("Ill typed macro (should be of type "^ty^")")
;;

let eval_macro_expr_ML e =
 match eval_prag_syntax e
 with dynamic (prg : ML) -> prg
    | d -> ill_typed_macro d "ML"
;;

let eval_macro_expr_bool test e_true e_false =
 match eval_prag_syntax test
 with dynamic (true:bool) -> e_true
    | dynamic (false:bool) -> e_false
    | d -> ill_typed_macro d "bool" ;;

let eval_macro_expr_MLtype e =
 match eval_prag_syntax e
 with dynamic (mlty: MLtype) -> mlty
    | d -> ill_typed_macro d "MLtype"
;;

let eval_macro_expr_MLpat_ML_list e=
 match eval_prag_syntax e
 with dynamic (l: (MLpat & ML) list) -> l
    | d -> ill_typed_macro d "(MLpat & ML) list"
;;

let eval_macro_expr_MLconstruct_list e =
 match eval_prag_syntax e
 with dynamic (l: MLconstruct list) -> l
    | d -> ill_typed_macro d "MLconstruct list"
;;

let eval_macro_expr_MLlabel_list e =
 match eval_prag_syntax e
 with dynamic (l: MLlabel list) -> l
    | d -> ill_typed_macro d "MLlabel list"
;;

let eval_macro_expr_MLorpat1 e orp =
 match eval_prag_syntax e
 with dynamic (p: MLpat) -> p::orp
    | d -> ill_typed_macro d "MLpat"
;;

let eval_macro_expr_MLorpat2 e p1 =
 match eval_prag_syntax e
 with dynamic (p2: MLpat) -> [p2;p1]
    | d -> ill_typed_macro d "MLpat"
;;

let eval_macro_expr_MLpat e =
 match eval_prag_syntax e
 with dynamic (prg: MLpat) -> prg
    | d -> ill_typed_macro d "MLpat"
;;


grammar for values Caml =

delimitors
    string is "\""
    comment is "%"
;
precedences
    right "->";
    right "or";
    right "&";
    right "<-" ":=";
    right ",";
    right INFIX;
    right "@" "^";
    right "::";
    left "+" "-";
    left "*" "/";
    precedence uminus;
    left ".";
    nonassoc "^}"
;


rule entry Caml =
    parse Caml_top t; Literal ";;" -> t

and Caml_top =
    parse Top_decl td -> MLdecl td
        | Expr e      -> ML e
        | Directive d -> MLdirective d
        | Gram g -> g
        | Macro_decl md  -> MLpragma md

and entry Pragma =
    parse Decl d; Literal ";;" -> Pragmadecl d
        | Expr e; Literal ";;" -> Pragmaexp e

and Expr0 =
    parse Ce c -> MLconst c
        | MLIdent2 x -> MLvar x
        | Ol_program ol;Literal ">>" -> ol
        | Literal "#"; IDENT x
            -> eval_macro_expr_ML (MLvar x)
        | Literal "#("; Expr e; Literal ")"
            -> eval_macro_expr_ML e

and Inj =
    parse Constructor c -> MLinj0 c
        | Constructor c1; Constructor c2 -> MLinj (c1,MLinj0 c2)
        | Constructor c; Expr0 e -> MLinj (c,e)

and Exp1 =
    parse Exp1 e; Literal "."; IDENT id -> MLrecord_access (id,e)
        | Exp1 e; Literal "."; NUM n
            -> MLvect_access (e,MLconst(mlnum n))
        | Exp1 e1; Literal "."; Literal "("; Expr e2; Literal ")"
            -> MLvect_access(e1,e2)
        | Expr0 e -> e

and Expr13 =
    parse Exp1 e1; Literal "."; IDENT v; Literal "<-"; Fnexpr13 e2
            -> MLupdate (v,e1,e2)
        | Exp1 e1; Literal "."; NUM n; Literal "<-"; Fnexpr13 e2
            -> MLvect_assign (e1,MLconst(mlnum n),e2)
        | Exp1 e1; Literal "."; Literal "("; Expr e2; Literal ")";
          Literal "<-"; Fnexpr13 e3
            -> MLvect_assign (e1,e2,e3)

and Ol_program =
    parse Literal "<<" -> parse_ol_grammar !default_ol_grammar
        | Syntax s -> parse_ol_grammar s

and Expr1 =
    parse Literal ("!" as bang); Expr1 e -> MLapply(MLvar bang,e,[])
        | Exp1 e -> e

and Exp2 =
    parse Literal "dynamic"; Expr1 e -> MLdynamic e
        | Expr1 e -> e

and Expr2 =
    parse Appexp e -> mkapply e
        | Inj i -> i
        | Exp2 e -> e

and Appexp =
    parse Exp2 e; Expr1 e_prime -> e_prime::[e]
       | Appexp e; Expr1 e_prime -> e_prime::e

and Expr8 =
    parse Expr8 e; INFIX i; Expr8 e_prime 
            -> MLapply(MLvar i, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("@" as a); Expr8 e_prime 
            -> MLapply(MLvar a, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("^" as c); Expr8 e_prime 
            -> MLapply(MLvar c, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("::" as dc); Expr8 e_prime 
            -> MLapply(MLvar dc, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("+" as p); Expr8 e_prime 
            -> MLapply(MLvar p, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("-" as m); Expr8 e_prime 
            -> MLapply(MLvar m, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("*" as st); Expr8 e_prime 
            -> MLapply(MLvar st, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("/" as d); Expr8 e_prime 
            -> MLapply(MLvar d, MLpair(e,e_prime),[])
        | "-"; Expr8 e with precedence uminus -> mkuminus e
        | Expr2 e -> e

and Expr9 =
    parse Expr8 e; Literal ("=" as eq); Expr8 e_prime
            -> MLapply(MLvar eq, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("<" as lt); Expr8 e_prime
            -> MLapply(MLvar lt , MLpair(e,e_prime),[])
        | Expr8 e; Literal (">" as gt); Expr8 e_prime
            -> MLapply(MLvar gt , MLpair(e,e_prime),[])
        | Expr8 e; Literal ("<=" as le); Expr8 e_prime
            -> MLapply(MLvar le , MLpair(e,e_prime),[])
        | Expr8 e; Literal (">=" as ge); Expr8 e_prime
            -> MLapply(MLvar ge , MLpair(e,e_prime),[])
        | Expr8 e; Literal ("<>" as diff); Expr8 e_prime
            -> MLapply(MLvar diff , MLpair(e,e_prime),[])
        | Expr8 e -> e

and Expr10 =
    parse Literal ("not" as n); Expr9 e -> MLapply(MLvar n, e,[])
        | Expr9 e -> e

and Expr12 =
    parse Expr12 e; Literal "or"; Expr12 e_prime
            -> MLcond(e, MLconst(mlbool true),e_prime)
        | Expr12 e; Literal "&"; Expr12 e_prime
            -> MLcond(e,e_prime, MLconst(mlbool false))
        | Expr10 e -> e

and Expr13 =
    parse Expr12 e; Literal ","; Fnexpr13 e_prime -> MLpair(e,e_prime)
        | Expr12 e -> e

and Expr14 =
    parse Expr13 e; Literal (":=" as ass); Fnexpr16 e_prime
            -> MLapply (MLvar ass,MLpair(e,e_prime),[])
        | "at"; MLIdent id; Literal "<-"; Fnexpr16 e -> MLreplace (id,e)
        | Expr13 e -> e

and Expr15 =
    parse Literal "raise"; Rs_expr e -> mkraise e
        | Literal "failwith"; Expr15 e -> mkraise ("failure",e)
        | Expr14 e -> e

and Rs_expr =
    parse Literal "("; Rs_expr e; Literal ")" -> e
        | MLIdent id; Fnexpr15 e -> (id,e)
        | MLIdent id -> (id, MLconst mlnull)

and Expr0 =
    parse Literal "fail" -> mkraise("failure", MLconst(mlstring "fail"))
        | Literal "continue" -> MLcontinue

and Expr0 =
    parse Literal "["; Exprs e; Literal "]" -> mklist e
        | Literal "[|"; Exprs es; Literal "|]" -> mkvect es
        | Literal "[|"; Literal "|]" -> mkvect []
        | Literal "[<"; Exprs es; Literal ">]" -> mkseg es
        | Literal "[<"; Literal ">]" -> mkseg []

and Exprs =
    parse Expr16 e -> [e]
        | Exprs e; Literal ";"; Expr16 e_prime -> e_prime::e

and If_expr16 =
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true; Cond c
            -> MLcond(test , e_true, c)
        | Literal "#"; Literal "if"; Expr test; Literal "then"; Expr0 e_true;
                Literal "else"; Expr0 e_false
            -> eval_macro_expr_bool test e_true e_false

and Cond =
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true; Cond c
            -> MLcond(test, e_true, c)
        | Literal "else"; Fnexpr16 e -> e
        |   -> MLconst mlnull

and Expr16 =
    parse If_expr16 e -> e
        | Expr15 e -> e

and Seqexpr16 =
    parse Seqexpr16 el; Literal ";"; Fnexpr16 e -> e::el
        | Fnexpr16 e -> [e]

and Expr17 =
    parse Expr16 e; Literal ";"; Seqexpr16 es -> mkseq (e, es)
        | Expr16 e -> e

and Fnexpr =
    parse Literal "fun"; Match m -> MLmatch m
        | Literal "function"; Umatch um -> MLmatch um
        | Literal "match"; Expr e; Literal "with"; Umatch um
            -> MLapply (MLmatch um, e, [])
        | Literal "case"; Expr e; Literal "of"; Umatch um
            -> MLapply (MLmatch um, e,[])
        | Literal "try"; Expr e; Literal "with"; Trymatch tm
            -> mkhandle (e, tm)
        | Decl d; Literal "in"; Expr e -> MLin (d,e)

and Fnexpr13 = parse Fnexpr e -> e | If_expr16 e -> e | Expr13 e -> e
and Fnexpr15 = parse Fnexpr e -> e | Expr15 e -> e
and Fnexpr16 = parse Fnexpr e -> e | Expr16 e -> e

and entry Expr =
    parse Literal "lazy"; Expr e -> MLeval_mode (Lazy,e)
        | Literal "freeze"; Expr e -> MLeval_mode1 (Lazy,e)
        | Literal "parallel"; Expr e -> MLeval_mode (Parallel,e)
        | Literal "future"; Expr e -> MLeval_mode1 (Parallel,e)
        | Literal "strict"; Expr e -> MLeval_mode (Strict,e)
        | Literal "force"; Expr e -> MLforce e
        | Literal "protect"; Expr e -> MLprotect e
        | Expr17 e1; Literal "?"; Expr e2
            -> MLhandle(e1,[(MLconpat("failure", MLwildpat)),e2])
        | Expr17 e; Literal "where"; Val_binding vb -> MLin(vb, e)
        | Expr17 e; Literal "where"; Literal "rec"; Val_binding vb
            -> MLin(MLrec vb, e)
        | Literal "vector"; Expr e_num; Literal "of"; Expr2 e_init
            -> MLinit_vect (MLmutable true,(e_num,e_init))
        | Literal "vector"; Literal "of"; Expr2 e_list
            -> MLvect_of_list (MLmutable true,e_list)
        | Literal "segment"; Expr e_num; Literal "of"; Expr2 e_init
            -> MLinit_vect (MLmutable false,(e_num,e_init))
        | Literal "segment"; Literal "of"; Expr2 e_init
            -> MLvect_of_list (MLmutable false,e_init)
        | Fnexpr e -> e
        | Expr17 e -> e

and Expr0 =
    parse Literal "("; Expr e; Literal ")" -> e
        | Literal "("; Expr e; Type_constraint str; Literal ")"
            -> MLstraint(e, str)
        | Literal "while"; Expr e_test;
          Literal "do"; Expr e_loop_step; Literal "done"
            -> MLwhile(e_test, e_loop_step)
        | Literal "begin"; Literal "do"; Expr17 e; Literal "end"; Literal "do"
            -> e
        | Literal "begin"; Literal "while"; Expr e_test; Literal "do";
          Expr e_loop_step; Literal "end"; Literal "while"
            -> MLwhile(e_test, e_loop_step)
        | Literal "begin"; Literal "fun"; Match m; Literal "end"; Literal "fun"
            -> MLmatch m
        | Literal "begin"; Literal "function"; Umatch um;
          Literal "end"; Literal "function"
            -> MLmatch um
        | Literal "begin"; Literal "match"; Expr e; Literal "with"; Umatch um;
          Literal "end"; Literal "match"
            -> MLapply(MLmatch um, e, [])
        | Literal "begin"; Literal "case"; Expr e; Literal "of"; Umatch um;
          Literal "end"; Literal "case"
            -> MLapply(MLmatch um, e, [])
        | Literal "begin"; Literal "try"; Expr e; Literal "with"; Trymatch tm;
          Literal "end"; Literal "try"
            -> mkhandle (e, tm)
        | Literal "begin"; Literal "if"; Expr e_test;
          Literal "then"; Expr e_true;
          Literal "else"; Expr e_false; Literal "end"; Literal "if"
            -> MLcond(e_test, e_true, e_false)
        | Literal "begin"; Literal "if"; Expr e_test;
          Literal "then"; Expr e_true; Literal "end"; Literal "if"
            -> MLcond(e_test, e_true, MLconst mlnull)
        | Literal "begin"; Literal "#"; Literal "if"; Expr e_test;
          Literal "then"; Expr0 e_true;
          Literal "else"; Expr0 e_false; Literal "end"; Literal "if"
            -> eval_macro_expr_bool e_test e_true e_false
        | Literal "{"; Field_list fl; Literal "}" -> MLrecord fl


and Field_list =
    parse Field1 f -> (f,[])
        | Field1 f; Literal ";"; Field_l fl -> (f,rev fl)

(* Will be:
and Field_list =
    parse Field1 f1; [*(parse Literal ";"; Field1 f -> f)] fl -> f1,fl
*)

and Field_l =
    parse Field1 f -> [f]
        | Field_l fl; Literal ";"; Field1 f -> f::fl

and Field1 =
    parse MLIdent id; Literal "="; Expr16 e -> (id,e)

and Type_constraint =
    parse Literal ":"; Type ty -> ty
        | Literal "#:"; Expr e
            -> eval_macro_expr_MLtype e

and Match =
    parse Match1 ml -> rev ml

and Match1 =
    parse Bpat1 p; Match_rule mr -> [(p, mr)]
        | Match1 ml; Literal "|"; Bpat1 p; Match_rule mr -> (p, mr)::ml
        | Match1 ml; Literal "#|"; Expr e
            -> rev_append (eval_macro_expr_MLpat_ML_list e) ml

and Match_rule =
    parse Bpat1 p; Match_rule mr -> MLmatch [p,mr]
        | Literal "->"; Expr e -> e

and Try_case =
    parse Pat p; Literal "->"; Literal "reraise" -> mkreraise p
        | Pat p; Literal "->"; Expr e; Literal "reraise" -> mkseqreraise (p,e)
        | Umatch_case umc -> umc

and Umatch_case = parse Pat p; Literal "->"; Expr e -> (p,e)

and Umatch =
    parse Umatch1 uml -> rev uml

and Umatch1 =
    parse Umatch_case umc -> [umc]
        | Umatch1 uml; Literal "|"; Umatch_case umc -> umc::uml
        | Umatch1 uml; Literal "#|"; Expr e
            -> rev_append (eval_macro_expr_MLpat_ML_list e) uml

and Trymatch = parse Trymatch1 tml -> rev tml

and Trymatch1 =
    parse Try_case tc -> [tc]
        | Trymatch1 tcl; Literal "|"; Try_case tc -> tc::tcl
        | Trymatch1 tcl; Literal "#|"; Expr e
            -> rev_append (eval_macro_expr_MLpat_ML_list e) tcl

and Top_decl =
    parse Literal "overload"; Overload_binding ovbl -> MLoverload (rev ovbl)
        | Literal "forward"; Forward_binding fbl -> MLforward (rev fbl)
        | Decl d -> d

and entry Gram =
    parse Literal "grammar" -> parse_grammar_decl()

and Decl =
    parse Literal "let"; Val_binding vb -> vb
        | Literal "let"; Literal "rec"; Val_binding vb -> MLrec vb
        | Literal "value"; Val_binding vb -> vb
        | Literal "value"; Literal "rec"; Val_binding vb -> MLrec vb
        | Literal "type"; Type_binding tb -> MLtype(rev tb)
(*
        | Literal "abstype"; Type_binding_c tb; Literal "with"; Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
        | Literal "abstype"; Type_binding_c tb; Literal "with" Literal "rec";
          Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
        | Literal "abstype"; Literal "rec"; Type_binding_c tb; Literal "with";
          Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
        | Literal "abstype"; Literal "rec"; Type_binding_c tb;
          Literal "with"; Literal "rec"; Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
*)
        | Literal "exception"; Exc_binding ebl -> MLexception(rev ebl)
        | Decl local_decl; Literal "in"; Decl decl -> MLlocal(local_decl,decl)
        | Literal "("; Decl d; Literal ")" -> d

and Val_binding =
    parse Val_binding0 vb -> mkdecl vb
        | Val_binding vb1; Literal "and"; Val_binding0 vb2
            -> binarize(vb1, mkdecl vb2)

and Val_binding0 =
    parse Bpat p; Beurk b
    (* s'appelait "b", mais je sais pce que c'est *)
            -> [p,b]
        | Bpat1 p1; Inf i; Bpat1 p2; Literal "="; Expr e
            -> [MLvarpat i, MLmatch[MLpairpat(p1, p2),e]]
        | Val_binding0 vb; Literal "|"; Bpat p; Beurk b -> (p, b)::vb

and Beurk =
    parse Bpat1 p; Beurk n -> MLmatch[p,n]
        | Literal "="; Expr e -> e

and Overload_binding =
    parse Overload_binding0 ov -> [ov]
        | Overload_binding ovl; Literal "and"; Overload_binding0 ov -> ov::ovl

and Overload_binding0 =
    parse MLIdent3 id; Literal "with"; MLIdent3l idl -> id,rev idl

and Forward_binding =
    parse MLIdent3_straint fb -> [fb]
        | Forward_binding fbl; Literal "and"; MLIdent3_straint fb -> fb::fbl

and MLIdent3_straint =
    parse MLIdent3 id; Type_constraint tc -> (id,tc)
        | Literal "("; MLIdent3 id; Type_constraint tc; Literal ")" -> (id,tc)

and Type_binding =
    parse Type_binding_1 tb
            -> (if !types_declared=[] then [tb]
                else let tbs = !types_declared in
                types_declared:=[];tbs@[tb])
        | Type_binding tbl; Literal "and"; Type_binding_1 tb
            -> (if !types_declared=[] then tb::tbl
                else let tbs = !types_declared in
                types_declared:=[];tbs @ tb::tbl)

and Type_binding_1 =
    parse Type_binding_c tb -> MLconcrete_type tb
        | Type_binding_r tb -> MLrecord_type tb
        | Type_binding_abb tb -> MLabbrev_type tb

and Type_binding_args =
    parse Var_tyargs vta; MLIdent2 id -> (id,vta)
        | Var_ty vt1; Infixes i; Var_ty vt2 -> (i,[vt1;vt2])

and Type_binding_r =
    parse Type_binding_args tbargs; Literal "="; Labels lbl
            -> mk_type_binding tbargs lbl

and Type_binding_abb =
    parse Type_binding_args tbargs; Literal "=="; Type_in_decl ty
            -> mk_type_binding tbargs ty

and Type_binding_c =
    parse Type_binding_args tbargs; Literal "="; Constructors constrs
            -> mk_type_binding tbargs constrs

and Labels = parse Labs l -> l
                 | Literal "{"; Labs l; Literal "}" -> l

and Constructors = parse Constr cl -> rev cl
                       | Literal "["; Constr cl; Literal "]" -> rev cl

and Type_in_decl =
    parse Type ty -> ty
        | Type ty; Literal "as"; Var_tyargs vty; MLIdent2 id
            -> (types_declared := MLabbrev_type(id,vty,ty)::!types_declared;
                ty)
        | Literal "{"; Labs lbs; Literal "}";
          Literal "as"; Var_tyargs vty; MLIdent2 id
            -> (types_declared := MLrecord_type(id,vty,lbs)::!types_declared;
                MLconsttyp(id,MLtypes_of_vars vty))
        | Literal "["; Constr c; Literal "]";
          Literal "as"; Var_tyargs vty; MLIdent2 id
            -> (types_declared:=MLconcrete_type(id,vty,rev c)::!types_declared;
                MLconsttyp(id, MLtypes_of_vars vty))

and Type_name = parse Var_tyargs vty; MLIdent2 id -> (id,vty)

and Var_tyargs =
    parse -> []
        | Var_ty v -> [v]
        | Literal "("; Var_tyl vtl; Var_ty v; Literal ")" -> rev (v::vtl)

and Var_tyl =
    parse -> []
        | Var_tyl vtl; Var_ty v; Literal "," -> v::vtl

and Constr =
    parse Constr cl; Literal "|"; Constr1 c -> c::cl
        | Constr1 c -> [c]
        | Constr c; Literal "#|"; Expr e
            -> rev_append (eval_macro_expr_MLconstruct_list e) c
and Constr1 =
    parse Constructor_or_ident id; Literal "of"; Type_in_decl ty
            -> MLconstruct (id,ty)
        | Literal "mutable"; Constructor_or_ident id; Literal "of";
          Type_in_decl ty
            -> MLqconstruct (id,standard_qlabel_qualificator,ty)
        | Literal "!"; Constructor_or_ident id; Literal "of"; Type_in_decl ty 
            -> MLqconstruct (id,standard_qlabel_qualificator,ty)
        | Literal "lazy"; Constructor_or_ident id; Literal "of";
          Type_in_decl ty 
            -> MLqconstruct (id,standard_llabel_qualificator,ty)
        | Literal "*"; Constructor_or_ident id; Literal "of"; Type_in_decl ty 
            -> MLqconstruct (id,standard_llabel_qualificator,ty)
        | Constructor_or_ident id -> MLconstruct0 id

and Labs =
    parse Lab1 l -> (l,[])
        | Lab1 l; Literal ";"; Labl ll -> (l,rev ll)

and Labl =
    parse Labl ll; Literal ";"; Lab1 l -> l::ll
        | Lab1 l -> [l]
        | Labl ll; Literal "#;"; Expr0 e
            -> rev_append (eval_macro_expr_MLlabel_list e) ll

and Lab1 =
    parse MLIdent id; Literal ":"; Type_in_decl ty -> MLlabel (id,ty)
        | Literal "mutable"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_qlabel_qualificator,ty)
        | Literal "!"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_qlabel_qualificator,ty)
        | Literal "lazy"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_llabel_qualificator,ty)
        | Literal "*"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_llabel_qualificator,ty)

and Exc_binding =
    parse Exc_binding ebl; Literal "and"; Exc_binding1 eb -> eb::ebl
        | Exc_binding1 eb -> [eb]

and Exc_binding1 =
    parse MLIdent id; Literal "of"; Type ty -> (id,ty)
        | MLIdent id -> (id,MLconsttyp("unit",[])) (* Unreasonable!!!! *)

and Pat1 =
    parse Constructor_or_ident id; Bpat1 p -> MLconpat(id,p)
        | Bpat1 p -> p

and Pat4 =
    parse Pat4 p1; Literal ","; Pat4 p2 -> MLpairpat(p1, p2)
        | Pat4 p1; INFIX i; Pat4 p2 -> MLconpat(i, MLpairpat(p1, p2))
        | Pat4 p1; Literal ("::" as c); Pat4 p2
            -> MLconpat(c, MLpairpat(p1, p2))
        | Pat1 p -> p

and Pat5 =
    parse Or_pat orp -> MLorpat(uncons (rev orp))
        | Pat4 p -> p

and Or_pat =
    parse Or_pat orp; Literal "|"; Pat4 p -> p::orp
        | Pat4 p1; Literal "|"; Pat4 p2 -> [p2;p1]
        | Or_pat orp; Literal "#|"; Expr e
            -> eval_macro_expr_MLorpat1 e orp
        | Pat4 p1; Literal "#|"; Expr e
            -> eval_macro_expr_MLorpat2 e p1

and entry Pat =
    parse Pat5 p; Literal "as"; MLIdent2 id -> MLsynpat(p,id)
        | Pat5 p -> p

and Bpat1 =
    parse Ce c -> MLconstpat c
        | Literal "_" -> MLwildpat
        | Literal "-"; NUM n with precedence uminus -> MLconstpat(mlnum (- n))
        | Constructor s -> MLcon0pat s
        | MLIdent2 id ->  MLvarpat id
        | Literal "strict"; MLIdent2 id -> MLstrictpat (MLvarpat id)
        | Ol_program ol_exp; Literal ">>" -> expr_to_pat ol_exp
        | Literal "#"; IDENT x
            -> eval_macro_expr_MLpat (MLvar x)
        | Literal "#("; Expr e; Literal ")"
            -> eval_macro_expr_MLpat e
        | Literal "["; Pats ps; Literal "]" ->  mkpatlist ps
(*        | Literal "[|"; Pats ps; Literal "|]" -> mkpatvect ps *)
(*         | Literal "[<"; Pats ps; Literal ">]" -> mkpatseg ps *)
        | Literal "{"; Lab_pats ps; Literal "}" -> mkpatrecord ps
        | Literal "("; Pat p; Literal ")" -> p
        | Literal "(" ; Pat p; Type_constraint str; Literal ")"
            -> MLstraintpat(p,str)
        | Bpat1 p; Literal "at"; MLIdent id -> MLoccpat (p,id)
        | Literal "dynamic"; Literal "("; Pat p;
          Type_constraint ty; Literal ")" -> MLdynpat(ty,p)

and Bpat =
    parse Bpat1 p1; Literal ","; Bpat p2 -> MLpairpat(p1,p2)
        | Bpat1 p -> p

and Pats =
    parse Pat p -> [p]
        | Pats ps; Literal ";"; Pat p -> p::ps

and Lab_pat =
    parse IDENT id; Literal "="; Pat p -> MLlabelpat (id,p)
        | IDENT id -> MLlabelpat (id,MLvarpat id)
        | Literal "_" -> MLlabelwildpat
 
and Lab_pats =
    parse Lab_pat lp -> [lp]
        | Lab_pats lps; Literal ";"; Lab_pat lp -> lp::lps

and Ce =
    parse NUM n -> mlnum n
        | INT i -> mlint i
        | FLOAT f -> mlfloat f
        | STRING s -> mlstring s
        | BOOL b -> mlbool b
        | Literal "("; Literal ")" -> mlnull
        | Literal "{"; Literal "}" -> mlnull

and Type1 =
    parse Var_ty vty -> MLvartyp vty
(*         | Esc_ty ety -> MLesctyp ety *)
        | MLIdent2 const -> MLconsttyp(const,[])
        | Literal "("; Type ty; Literal ")" -> ty
        | Type1 tyarg; MLIdent2 tyco -> MLconsttyp(tyco,[tyarg])
        | Literal "("; Typel args; Type arg; Literal ")"; MLIdent2 ty
            -> MLconsttyp(ty,rev (arg::args))

and Typel =
    parse Typel tyl; Type ty; Literal "," -> ty::tyl
        | Type ty; Literal "," -> [ty]

and Type2 =
    parse Type1 ty1; Type_infixes tyi; Type2 ty2
            -> MLconsttyp(tyi,[ty1;ty2])
        | Type1 ty -> ty

and entry Type =
    parse Type tysrc; Literal ("->" as arrow); Type tygl
            -> MLconsttyp(arrow,[tysrc;tygl])
        | Type2 ty1; Literal ("*" as b_and); Type ty2
            -> MLconsttyp(b_and,[ty1;ty2])
        | Type2 ty -> ty

and Var_ty = parse Literal "'"; MLIdent var -> var

and MLIdent0 = parse IDENT var -> var
                   | Literal "["; Literal "]" -> ""

and MLIdent = parse MLIdent0 var -> var
                | MLInfix i -> i

and Prefix_Ident = parse Literal "prefix"; MLInfix i -> i

and MLIdent2 =
    parse MLIdent0 var -> var | Prefix_Ident var -> var

and MLIdent3 =
    parse IDENT var -> var | Prefix_Ident var -> var

and Constructor =
    parse Literal "'"; MLIdent2 id -> id

and Constructor_or_ident =
    parse Constructor c -> c | MLIdent2 id -> id

and Inf =
    parse INFIX i -> i
        | Literal ("+" as p) -> p
        | Literal ("/" as d) -> d  | Literal ("<=" as l) -> l
        | Literal (">=" as g) -> g | Literal ("<>" as d) -> d
        | Literal ("<" as l) -> l  | Literal (">" as g) -> g
        | Literal ("::" as c) -> c | Literal ("@" as a) -> a
        | Literal ("&" as m) -> m  | Literal ("or" as d) -> d
        | Literal ("^" as c) -> c

and Type_infixes =
    parse Inf i -> i | Literal ("-" as m) -> m
        | Literal ("=" as e) -> e

and Infixes = parse
          Type_infixes i -> i
        | Literal ("*" as a) -> a
        | Literal (":=" as a) -> a

and Prefixes = parse Literal ("not" as n) -> n | Literal ("!" as b) -> b

and MLInfix = parse Infixes i -> i | Prefixes p -> p

and Directive = parse Literal "directive"; Expr e -> Pragmaexp e

and Macro_decl =
    parse Literal "mlet"; Val_binding vb -> Pragmadecl vb
        | Literal "mlet"; Literal "rec"; Val_binding vb
            -> Pragmadecl (MLrec vb)

and Syntax =
    parse  Literal "<:"; IDENT sname; Literal ":"; IDENT ext; Literal "<"
            -> (sname,ext)
        | Literal "<:"; IDENT sname; Literal "<" -> (sname, "")

and entry Export_list =
    parse Export1 exp -> [exp]
        | Export_list expl; Literal ";"; Export1 exp -> exp::expl

and Export1 =
    parse Literal "value"; MLIdentl idl -> "value"::idl
        | Literal "type"; MLIdentl idl -> "type"::idl
        | Literal "abstype"; MLIdentl idl -> "abstype"::idl
        | Literal "exception"; MLIdentl idl -> "exception"::idl

and entry Import_list =
    parse Import2 imp -> imp,[]
        | Import2 imp; Literal "from"; File_list fl -> imp, rev fl
        
and File_list = parse STRING name -> [name]
                    | File_list fl; Literal ","; STRING name -> name::fl

and Import2 = parse Import1 imp -> [imp]
                  | Import2 impl; Literal ";"; Import1 imp -> imp::impl

and Import1 =
    parse Literal "value"; Straint_list strl -> MLlet(strl,MLconst mlnull)
        | Literal "type"; Type_binding tyl ->  MLtype (rev tyl)
        | Literal "type"; Type_name tyn -> MLtype [MLunknown_type tyn]
        | Literal "exception"; Exc_binding eb -> MLexception (rev eb)

and MLIdentl = parse MLIdent3 id -> [id]
                 | MLIdentl idl; Literal "and"; MLIdent3 id -> id::idl

and MLIdent3l = parse MLIdent3 id -> [id]
                  | MLIdent3l idl; Literal ","; MLIdent3 id -> id::idl

and entry Straint_list =
    parse MLIdent3_straint str -> MLstraintpat(MLvarpat (fst str), snd str)
        | Straint_list strl; Literal "and"; MLIdent3_straint str
            -> MLpairpat(strl, MLstraintpat(MLvarpat (fst str), snd str))

;;

let coerce_to_MLsyntax f arg =
    match eval_syntax(f arg)
    with dynamic (s: MLsyntax) -> s
       | _ -> system_error "Ill built syntax"

and coerce_to_ML f arg =
    match eval_syntax(f arg)
    with dynamic (s: ML) -> s
       | _ -> system_error "Ill built syntax"

and coerce_to_MLpat f arg =
    match eval_syntax(f arg)
    with dynamic (s: MLpat) -> s
       | _ -> system_error "Ill built syntax"

and coerce_to_MLtype f arg =
    match eval_syntax(f arg)
    with dynamic (s: MLtype) -> s
       | _ -> system_error "Ill built syntax"

;;

let parse_caml_expr = coerce_to_ML (Caml "Expr").Parse_raw
and parse_caml_pat =  coerce_to_MLpat (Caml "Pat").Parse_raw
and parse_caml_typ = coerce_to_MLtype (Caml "Type").Parse_raw
and parse_caml = coerce_to_MLsyntax (Caml "Caml").Parse_raw
and parse_caml_pragma = (Caml "Pragma").Parse_raw
and parse_caml_straint_list = (Caml "Straint_list").Parse_raw
and parse_caml_import_list = (Caml "Import_list").Parse_raw
and parse_caml_export_list = (Caml "Export_list").Parse_raw
;;

#end module
with value parse_caml_expr
       and parse_caml_pat
       and parse_caml_typ
       and parse_caml
       and parse_caml_pragma
       and parse_caml_straint_list
       and parse_caml_import_list
       and parse_caml_export_list
;;
