(*
$File: Compiler/DECISION_LIST.sml $
$Date: 1992/09/17 14:17:49 $
$Revision: 1.1 $
$Locker:  $
*)

(*$DECISION_LIST*)

(* In a lot of cases, we are actually dealing with sets of decisions rather
   lists of them, but that gets unweildy. Equality over decisions gets awkward
   since the datatype is recursive and hence contains sets, and I don't know
   what it would do for the efficiency... Perhaps decision lists should
   actually be maps from labels or something. *)

signature DECISION_LIST =
  sig
    type lab
    type RuleNum sharing type RuleNum = int
    type con
    type scon
    type longexcon
    type TypeInfo
    type (''a, 'b) map

    datatype Decision =
      DECISION of {path: (lab * TypeInfo) list,
		   select: Select,
		   defaults: RuleNum EqSet.Set
		  }

    and Select = CON_SELECT of (con, TypeInfo * SubDecision) map
               | SCON_SELECT of (scon, SubDecision) map
               | EXCON_SELECT of (longexcon * SubDecision) list
			(* a list (right way round this time) because the EXCONs
			   have to be tested in order. *)

    and SubDecision =
      SUB_DECISION of {rules: RuleNum EqSet.Set, decisions: Decision list}

    type AndOrTree
    val decisions: AndOrTree -> Decision list

    type StringTree
    val layoutDecision: Decision -> StringTree
  end;
