(* Type names - Definition v3 page 16 *)

(*
$File: Common/TYNAME.sml $
$Date: 1992/08/19 14:47:54 $
$Revision: 1.10 $
$Locker: birkedal $
*)

(*$TYNAME*)
signature TYNAME =
  sig 
    eqtype TyName

    val tyName_INT     : TyName
    and tyName_STRING  : TyName
    and tyName_REAL    : TyName
    and tyName_EXN     : TyName
    and tyName_REF     : TyName
    and tyName_BOOL    : TyName

    type tycon

    val arity    : TyName -> int
    and equality : TyName -> bool
    and name     : TyName -> tycon

    val freshTyName : {name : tycon, arity : int, equality : bool} -> TyName

    val pr_TyName : TyName -> string
  end;
