(* Grammar for modules - Definition v3 pages 12-14 *)

(*
$File: Common/TOPDEC_GRAMMAR.sml $
$Date: 1993/03/05 14:39:09 $
$Revision: 1.12 $
$Locker: birkedal $
*)

(*$TOPDEC_GRAMMAR*)

signature TOPDEC_GRAMMAR =
  sig
    (* Core declarations. *)

    type dec

    (* Various kinds of module identifiers. *)

    type strid
    type longstrid
    type funid
    type sigid

    (* Objects from the core syntax (needed for specs). *)

    type id
    type tyvar
    type ty
    type tycon
    type longtycon
    type con
    type excon

    (* info place-holder. *)

    type info

    datatype 'a WithInfo = WITH_INFO of info * 'a

			    (* Figure 6 *)

    datatype strexp =
      STRUCTstrexp of info * strdec |
      LONGSTRIDstrexp of info * longstrid |
      APPstrexp of info * funid * strexp |
      LETstrexp of info * strdec * strexp

    and strdec =
      DECstrdec of info * dec |
      STRUCTUREstrdec of info * strbind |
      LOCALstrdec of info * strdec * strdec |
      EMPTYstrdec of info |
      SEQstrdec of info * strdec * strdec

    and strbind =
      STRBIND of info * strid * sigexp Option * strexp * strbind Option

    and sigexp =
      SIGsigexp of info * spec |
      SIGIDsigexp of info * sigid

    and sigdec =
      SIGNATUREsigdec of info * sigbind |
      EMPTYsigdec of info |
      SEQsigdec of info * sigdec * sigdec

    and sigbind =
      SIGBIND of info * sigid * sigexp * sigbind Option

			    (* Figure 7 *)

    and spec =
      VALspec of info * valdesc |
      TYPEspec of info * typdesc |
      EQTYPEspec of info * typdesc |
      DATATYPEspec of info * datdesc |
      EXCEPTIONspec of info * exdesc |
      STRUCTUREspec of info * strdesc |
      SHARINGspec of info * shareq |
      LOCALspec of info * spec * spec |
      OPENspec of info * longstrid WithInfo list |
      INCLUDEspec of info * sigid WithInfo list |
      EMPTYspec of info |
      SEQspec of info * spec * spec

    and valdesc =
      VALDESC of info * id * ty * valdesc Option

    and typdesc =
      TYPDESC of info * tyvar list * tycon * typdesc Option

    and datdesc =
      DATDESC of info * tyvar list * tycon * condesc * datdesc Option

    and condesc =
      CONDESC of info * con * ty Option * condesc Option

    and exdesc =
      EXDESC of info * excon * ty Option * exdesc Option

    and strdesc =
      STRDESC of info * strid * sigexp * strdesc Option

    and shareq =
      STRUCTUREshareq of info * longstrid WithInfo list |	(* >= 2 *)
      TYPEshareq of info * longtycon WithInfo list |		(* >= 2 *)
      ANDshareq of info * shareq * shareq

			    (* Figure 8 *)

    and fundec =
      FUNCTORfundec of info * funbind |
      EMPTYfundec of info |
      SEQfundec of info * fundec * fundec

    and funbind =
      FUNBIND of info * funid * strid * sigexp * sigexp Option * strexp * funbind Option

    and topdec =
      STRtopdec of info * strdec |
      SIGtopdec of info * sigdec |
      FUNtopdec of info * fundec

    val getExplicitTyVarsCondesc : condesc -> tyvar list
  end;
