;;; -*- Mode: Lisp, Fill, Save; Package: USER -*-
;;; 
;;; ______________________________________________________________________
;;;
;;; This code was written as part of the Garnet (User Interface) project at
;;; Carnegie-Mellon University, and has been placed in the public domain.
;;; If you want to use this code or anything developed as part of the Garnet
;;; Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;

#|
============================================================
Change log:
         6/7/89 Brad Vander Zanden - Created
============================================================
|#

(format t "Loading Lapidary...~%")
(setf *load-verbose* t)

;; check first to see if place is set
(unless (boundp 'Garnet-Lapidary-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Lapidary-PathName before loading lapidary."))

;;; Load Aggregadgets unless already loaded  (this will load the lower 
;;; layers of Garnet if necessary)
#+cmu
(unless (get :garnet-modules :aggregadgets)
  (load Garnet-Aggregadgets-Loader))

#+(not cmu)
(require 'opal Garnet-Aggregadgets-Loader)

(setf Garnet-Gilt-BitMap-PathName "/azure/homes/bvz/garnet/gilt/")

(format t "~%*** Loading default mouse bindings ***~%")
(load (merge-pathnames "mouse-bindings"
	               user::Garnet-Lapidary-PathName)
	:verbose T)


;; load necessary gadgets
(dolist (loader-file '("text-buttons-loader"
			"error-gadget-loader"
                 	"arrow-line-loader"
		 	"labeled-box-loader"
		 	"x-buttons-loader"
	 	 	"v-slider-loader"
		 	"scrolling-labeled-box-loader"
		 	"radio-buttons-loader"
	 	 	"scrolling-window-loader"
		 	"scrolling-menu-loader"
			"prop-sheet-win-loader"))
 (load (merge-pathnames loader-file
                           #+cmu "gadgets:"
                           #+(not cmu) user::Garnet-Gadgets-PathName)
          :verbose T))

;;;
;;;     Functions needed from Gilt
(load (merge-pathnames "gilt-functions-loader"
			 user::Garnet-Gilt-PathName))

;; ---- Load Lapidary itself

(Defparameter Garnet-Lapidary-Files
  '(	
	"parameters"
        "defs"
    "line-constraint-defs"
        "macros"
        "lapidary-functions-loader" ; only load if not already loaded
	"lapidary"  
;    "test"
    "dialog-parts2" "card"
	"start-where" "prompt"
        "lapidary-objects"
    "feedback-objs"     "set-feedback"
	"support-misc"
	"support-properties"
	"support-selection1"	"support-selection2"   	"selection"
	"create-object"
	"delete-object"
        "delete-window"
	"move-grow"
	"support-constraints" "attach-constraints"
    "aggregates"
 
    "box-parts" "box" "support-box-constraints"
    "line-constraint-objs" "new-line-constraint"
    
    "properties"
;    "shades" 
        "line-imp" "line-props"
	"fill-imp" "fill-props"
	"color-imp" "color-props"
))

(dolist (file Garnet-Lapidary-Files)
  (load (merge-pathnames file 
			 #+cmu "lapidary:"
			 #+(not cmu) Garnet-Lapidary-PathName
			 )
	:verbose T))

(setf (get :garnet-modules :lapidary)  t)
(provide 'lapidary)
(setf lapidary::*load-db* nil)

(format t "...Done Lapidary.~%")

