(defvar *link-cell-list* nil)

(defvar *bold-font* (create-instance NIL opal:font (:face :bold)))
(defvar *very-large-bold-italic-serif-font*
  (create-instance NIL opal:font
     (:size :very-large) (:face :bold-italic) (:family :serif)))

(create-instance 'w1 inter:interactor-window
   (:aggregate (create-instance 'a1 opal:aggregate)))

(create-instance 'link-query-window inter:interactor-window
		 (:visible nil))
(create-instance 'link-query-agg opal:aggregadget
     (:string "")
     (:parts `((:message ,opal:multi-text
		 (:left 10) (:top 10)
		 (:string ,(o-formula (gvl :parent :string))))
	       (:ok-cancel ,garnet-gadgets:text-button-panel
		 (:width 147)
		 (:left ,(o-formula (opal:gv-center-x-is-center-of
				     (gvl :parent :message))))
		 (:top ,(o-formula (+ 10 (opal:gv-bottom (gvl :parent :message)))))
		 (:items ("OK" "Cancel"))
		 (:direction :horizontal)
		 (:selection-function check-for-linkname-conflicts)))))

(s-value link-query-window :aggregate link-query-agg)


(defun check-for-linkname-conflicts (gadget value)
  (declare (ignore gadget))
  (declare (special *selection-info*))
  (when (string= value "OK")
      (let* ((p-selections (g-value *selection-info* :custom-selected))
	     (links (g-value *selection-info* :links))
	     conflicts p-selection)
	(setf p-selection (pop p-selections))
	(loop (when (null p-selection)
		    (return))
	      (dolist (link links)
		      (when (has-slot-p p-selection (car link))
			    (push (car link) conflicts)))
	      (when conflicts
		    (s-value link-query-window :visible t)
		    (s-value *selection-info* :custom-selected
			     p-selections)
		    (s-value link-query-agg :string
			     (format nil "The following linknames conflict with existing slot-names
in the inverted object (~S)
~S" p-selection conflicts))
		    (return-from check-for-linkname-conflicts))
	      (setf p-selection (pop p-selections)))))
  (s-value link-query-window :visible nil))

#|
	(when (or (not type) (is-a-p schema type))
	      (undo-save schema link-name)
	      (if (common-ancestor-p schema obj)
		  (s-value schema link-name 
			   (formula `(gvl ,@(make-path schema obj))))
		  (s-value schema link-name obj))))))
|#
(defun custom-ok-cancel-function (gadget value)
  (declare (special *selection-info*))
  (cond ((or (string= value "Apply") (string= value "OK"))
	 (s-value *selection-info* :custom-selected
		  (g-value *selection-info* :p-selected))
	 (s-value *selection-info* :links (gather-links))
	 (check-for-linkname-conflicts nil "OK"))))

(defun gather-links ()
  (declare (ignore gadget value))
  (let (links)
    (dolist (link (g-value custom-constraint-gadget :links :components))
	    (push (cons (read-from-string (g-value link :link :value))
			(g-value link :link-value :selection))
		  links))
    links))

(defun valid-keyword-p (value)
  (keywordp (read-from-string value)))

(defun scrolling-input-string-type-check-start-action (inter obj event)
  (kr::call-prototype-method inter obj event)
  (s-value (g-value inter :operates-on) :old-value
	   (g-value inter :operates-on :value)))

(defun type-check-stop-action (interactor obj event final-string x y)
  (let ((gadget (g-value interactor :operates-on)))
    (kr::call-prototype-method interactor obj event final-string x y)
    (when (g-value gadget :type-function)
	  (when (not (funcall (g-value gadget :type-function) final-string))
		(s-value gadget :value (g-value gadget :old-value))
		(when (g-value gadget :type)
		      (lapidary-error 
		       (format nil "The value must be a ~A" 
			       (g-value gadget :type))))))))

(create-instance 'sis-type-check garnet-gadgets:SCROLLING-INPUT-STRING
	(:interactors `((:text-edit :modify
	    (:final-function type-check-stop-action)
	    (:start-action scrolling-input-string-type-check-start-action))))
	(:type-function nil)
	(:type nil))

(defun add-link (gadget value)
  (declare (ignore gadget value))
  (declare (special custom-constraint-gadget))
  (let (link-obj
	(links-agg (g-value custom-constraint-gadget :links)))
    
    (when (null (g-value *selection-info* :s-selected))
	  (lapidary-error "you must have one or more secondary selections 
before adding a link")
	  (return-from add-link))
    (dolist (obj (g-value *selection-info* :s-selected))
	    (setf link-obj (or (pop *link-cell-list*)
			       (create-instance nil link-cell)))
	    (s-value (g-value link-obj :link-value) :selection obj)
	    (s-value (g-value link-obj :link) :value ":linkname")
	    (opal:add-component links-agg link-obj))))

(defun delete-link (gadget value)
  (declare (ignore gadget value))
  (declare (special custom-constraint-gadget))
  (let ((link-obj (g-value custom-constraint-gadget :links :selection)))
    (when (null link-obj)
	  (lapidary-error "must select a link first")
	  (return-from delete-link))
    (s-value (g-value custom-constraint-gadget :links) :selection nil)
    (s-value (g-value custom-constraint-gadget :final-feedback) :obj-over nil)
    (opal:remove-component (g-value custom-constraint-gadget :links)
			   link-obj)
    (push link-obj *link-cell-list*)))

;; the following type is defined so that the link-selector interactor
;; can select just link-frames

(create-instance 'link-frame opal:rectangle
	 (:left (o-formula (gvl :parent :left)))
         (:top (o-formula (gvl :parent :top)))
	 (:width 150)
	 (:height 20))

;; the following type is defined so that the link-value-selector interactor
;; can select just link-value-frames

(create-instance 'link-value-frame opal:rectangle
	 (:left (o-formula (opal:gv-right (gvl :parent :link-frame))))
	 (:top (o-formula (gvl :parent :top)))
	 (:width 200)
	 (:height (o-formula (gvl :parent :link-frame :height))))

(create-instance 'link-cell opal:aggregadget
   (:left 10)
   (:top 200)
   (:parts `(
      (:link-frame ,link-frame)
      (:link ,sis-type-check
         (:left ,(o-formula (+ (gvl :parent :left) 10)))
         (:top ,(o-formula (opal:gv-center-y-is-center-of 
			    (gvl :parent :link-frame))))
	 (:height ,(o-formula (gvl :string :height)))
	 (:type-function valid-keyword-p)
	 (:type "keyword")
	 (:interactors ((:text-edit :modify (:start-event :rightdown))))
	 (:value ":linkname"))
      (:frame ,link-value-frame)
      (:link-value ,opal:text
	 (:selection nil)
	 (:string ,(o-formula (if (gvl :selection)
		      (let ((string (princ-to-string 
				     (or (gvl :selection :known-as)
					 (kr::schema-name (gvl :selection))))))
			(if (< (length string) 25)
			    string
			    (concatenate 'string (subseq string 0 22) "..."))))
		      ""))
	 (:left ,(o-formula (+ (gvl :parent :frame :left) 10)))
	 (:top ,(o-formula (opal:gv-center-y-is-center-of (gvl :parent :frame))))))))

(create-instance 'custom-constraint-gadget opal:aggregadget
  (:left 10)
  (:top 10)
  (:slotname nil)
  (:parts `(
    (:title ,opal:text
	    (:font ,*very-large-bold-italic-serif-font*)
	    (:string "Custom Constraint")
	    (:left 10)
	    (:top 10))
    (:instructions ,opal:multi-text
		   (:left 10)
		   (:top ,(o-formula (+ (opal:gv-bottom (gvl :parent :title))
					10)))
		   (:string "to be
filled in later"))
    (:slot-info ,link-cell
		(:left 10)
		(:top ,(o-formula (+ (opal:gv-bottom 
				      (gvl :parent :instructions))
				     10))))
    (:link-title ,opal:text
		 (:left ,(o-formula (opal:gv-center-x-is-center-of 
				     (gvl :parent :links))))
		 (:font ,*bold-font*)
		 (:top ,(o-formula (+ (opal:gv-bottom 
				      (gvl :parent :slot-info))
				     10)))
		 (:visible ,(o-formula (gvl :parent :links :components)))
		 (:string "links"))
    (:links ,opal:aggrelist
	    (:left 10)
	    (:width 351)
	    (:v-spacing 1)
	    (:height ,(o-formula (* (list-length (gvl :components)) 20)))
	    (:top ,(o-formula (+ (opal:gv-bottom (gvl :parent :link-title)) 10))))
    (:formula-buttons ,GARNET-GADGETS:TEXT-BUTTON-PANEL
      (:SELECTION-FUNCTION GILT:OKCANCEL-FUNCTION)
      (:ITEMS (("Add Link" add-link) ("Delete Link" delete-link)))
      (:GRAY-WIDTH 3)
      (:FINAL-FEEDBACK-P NIL)
      (:TEXT-OFFSET 2)
      (:SHADOW-OFFSET 5)
      (:DIRECTION :HORIZONTAL)
      (:LEFT 10)
      (:TOP ,(o-formula (if (gvl :parent :links :visible)
			    (+ (opal:gv-bottom (gvl :parent :links)) 10)
			    (+ (opal:gv-bottom (gvl :parent :slot-info)) 10)))))
    (:formula-frame ,opal:rectangle
	      (:left 10)
	      (:top ,(o-formula (+ (opal:gv-bottom (gvl :parent :formula-buttons)) 10)))
	      (:width ,(o-formula (max (+ (gvl :parent :formula :width) 20) 
				       350)))
	      (:height ,(o-formula (max (+ (gvl :parent :formula :height) 20) 
					100))))
    (:formula ,opal:cursor-multi-text
	      (:left 20)
	      (:top ,(o-formula (+ (gvl :parent :formula-frame :top) 10))))
    (:control-buttons ,GARNET-GADGETS:TEXT-BUTTON-PANEL
      (:SELECTION-FUNCTION custom-ok-cancel-function)
      (:ITEMS ("OK" "Apply" "Cancel"))
      (:GRAY-WIDTH 3)
      (:FINAL-FEEDBACK-P NIL)
      (:TEXT-OFFSET 2)
      (:SHADOW-OFFSET 5)
      (:DIRECTION :HORIZONTAL)
      (:LEFT ,(o-formula (+ (opal:gv-right (gvl :parent :title)) 20)))
      (:TOP 13))
    (:final-feedback ,opal:rectangle
      (:filling-style ,opal:black-fill)
      (:line-style nil)
      (:draw-function :xor)
      (:left 10)
      (:top ,(o-formula (gvl :obj-over :top)))
      (:width ,(o-formula (gvl :obj-over :width)))
      (:height 20)
      (:visible ,(o-formula (gvl :obj-over))))))
  (:interactors `(
     (:formula-interactor ,inter:text-interactor
        (:window ,(o-formula (gvl :operates-on :window)))
	(:start-where ,(o-formula (list :in (gvl :operates-on :formula-frame))))
	(:obj-to-change ,(o-formula (gvl :operates-on :formula)))
	(:start-event :rightdown)
	(:stop-event :any-mousedown))
     (:link-selector ,inter:button-interactor
	(:window ,(o-formula (gvl :operates-on :window)))
	(:final-function ,#'(lambda (inter obj)
			     (s-value (g-value inter :operates-on :links)
				      :selection obj)))
	(:start-where ,(o-formula (list :check-leaf-but-return-element
					(gvl :operates-on :links)
					:type link-frame)))
	(:final-feedback-obj ,(o-formula (gvl :operates-on :final-feedback)))
	(:how-set :toggle))
     (:link-value-selector ,inter:button-interactor
	(:window ,(o-formula (gvl :operates-on :window)))
	(:start-where ,(o-formula (list :leaf-element-of
					(gvl :operates-on :links)
					:type link-value-frame)))
	(:final-function ,#'(lambda (inter selection)
            (let ((value (car (g-value *selection-info* :s-selected))))
	      (when value
		    (s-value (g-value selection :parent :link-value)
			     :selection value)))))))))



(opal:add-components a1 custom-constraint-gadget)

(opal:Update-all)
(inter:main-event-loop)


