;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-

;;; Created 6/25/92 RGA

;;; Loader for protected eval stuff.

(in-package "USER" :use '("LISP"))

;; check first to see if place is set
(unless (boundp 'Garnet-Contrib-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Contrib-PathName
before loading Contributed Gadgets."))

(unless (get :garnet-modules :protected-eval)
  (format t "Loading Protected-Eval~%")
  (dolist (pair '((:error-gadget "garnet-error-gadget-loader")))
    (unless (get :garnet-modules (car pair))
      (load (merge-pathnames (cadr pair)
			     #+cmu "gadgets:"
			     #+(not cmu) Garnet-Gadgets-PathName)
	    :verbose T)))
  (dolist (pair '((:protected-eval "protected-eval")))
    (unless (get :garnet-modules (car pair))
      (load (merge-pathnames (cadr pair)
			     #+cmu "contrib:"
			     #+(not cmu) Garnet-Contrib-PathName)
	    :verbose T)))
  (format t "...Done Protected-Eval.~%"))

(setf (get :garnet-modules :Protected-Eval) t)

