Amiga user manual                                 Amiga user manual

NAME
     clisp - Common Lisp language interpreter and compiler

SYNOPSIS
     clisp [ -h ] [ -m memsize ] [ -s stacksize ] [ -M memfile  ]
     [ -q ] [ -i initfile ...  ] [ -c [ -l ] lispfile ...  ] [ -x
     expression ]

DESCRIPTION
     Invokes the common lisp interpreter and  compiler.   Invoked
     without arguments, executes a read-eval-print loop, in which
     expressions are in turn read from standard input,  evaluated
     by  the  lisp interpreter, and their results output to stan-
     dard output.  Invoked with -c, the specified lisp files  are
     compiled  to  a  bytecode  that  can  be executed more effi-
     ciently.

OPTIONS
     -h   Displays a help message on how to use clisp.

     -m memsize
          Sets the amount  of  memory  clisp  tries  to  grab  on
          startup.   The amount may be given as nnnnnnn (measured
          in bytes), nnnnK or nnnnKB (measured in  kilobytes)  or
          nM  or nMB (measured in megabytes).  Default is 2 mega-
          bytes.  The argument is constrained between 100 KB  and
          8 MB.

     -s stacksize
          Specifies the stacksize which is to be given to  CLISP.
          The  format  is  the  same as for the -m option. A zero
          size tells CLISP not to allocate stack on its own.  You
          have  to  start  CLISP  with  a stack size of 100-200KB
          yourself.

     -M memfile
          Specifies the initial memory image.   This  must  be  a
          memory dump produced by the saveinitmem function.

     -q   Quiet: clisp displays  no  banner  at  startup  and  no
          good-bye message when quitting.

     -i initfile ...
          Specifies initialization files to be loaded at startup.
          These should be lisp files (source or compiled).

     -c lispfile ...
          Compiles the specified lispfiles to bytecode. The  com-
          piled  files  can then be loaded instead of the sources
          to gain efficiency.

     -l   A bytecode listing of the files being compiled will  be
          produced.  Useful only for debugging purposes.

     -x expressions
          Executes a series of arbitrary expressions instead of a
          read-eval-print  loop.   The  values of the expressions
          will be output to standard output.  Due to the argument
          processing  done  by the shell, the expressions must be
          enclosed  in  single  quotes,  and  double  quotes  and
          backslashes must be preceded by backslashes.

WORKBENCH
     Two kinds of tooltypes are supported:

     WINDOW= console window or pipe specification
          Specifies the stream that clisp will talk to.

     ARGS= CLI-like argument line
          Therein * is recognized as a special token and replaced
          by  the  project's filename. If no ARGS tooltype is set
          for a project, it defaults to -i *.

REFERENCE
     The language implemented conforms to
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 1st edition 1984, 465 pages.
            ("CLtL1" for short)
     and to the older parts of
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 2nd edition 1990, 1032 pages.
            ("CLtL2" for short)

USE
     help to get some on-line help.

     (apropos name)
          lists the symbols relating to name.

     (exit) or (quit) or (bye)
          to quit clisp.

     EOF (Ctrl-\)
          to leave the current read-eval-print loop.

FILES
     lisp.run
          main executable

     lispinit.mem
          initial memory image

     config.lsp
          site-dependent configuration

     *.lsp
          lisp source

     *.fas
          lisp code, compiled by clisp

     *.lib
          lisp source library information, generated and used  by
          the clisp compiler

ENVIRONMENT
SEE ALSO
     cmulisp(1), emacs(1).

BUGS
     The function inspect is not implemented.

     The memory management scheme is not very flexible.

     Only very few extension from CLtL2 are supported.

     No on-line documentation  beyond  apropos  and  describe  is
     available.

     The function sublis behaves incorrectly  in  presence  of  a
     :key argument.

PROJECTS
     Writing on-line documentation.

     Building a foreign function interface  (ability  to  call  C
     code directly).

     Write inspect.

     Enhance the compiler such that it  can  inline  local  func-
     tions.

     Specify a portable set of window and graphics operations.

AUTHORS
     Bruno Haible <haible@ma2s2.mathematik.uni-karlsruhe.de>  and
     Michael Stoll.

     Amiga port: Joerg Hoehle <hoehle@inf-wiss.ivp.uni-konstanz.de>

-----
