      SUBROUTINE GRINIT(SIZEX,SIZEY,TITLE)
C! Initialise the graphics package
C SIZEX is the (real) width of the plot (world coords)
C SIZEY               height
C TITLE is the text of the title
C
C The purpose of the routine is to initialise the
C graphics environment to a plot of dimensions
C sizex,sizey, with appropriate text height .
C At the end of processing, ENTRY GRCLOSE is called
C to terminate the plot.
C
      INCLUDE 'jobcom.h'
      INCLUDE 'lunits.h'
      CHARACTER*(*) TITLE
C
      FACX = SIZEX/7.
      FACY = SIZEY/7.
      L = LENOCC(TITLE)
      WRITE(LOUTCH,'(A)') '%! PostScript output from FLOW'
      WRITE(LOUTCH,'(A)') '/inch { 72 mul } def'
      WRITE(LOUTCH,*) '/xrel { ',facx,' div inch } def'
      WRITE(LOUTCH,*) '/yrel { ',facy,' div inch } def'
      WRITE(LOUTCH,*) '/Helvetica-Bold findfont 14 scalefont setfont'
      WRITE(LOUTCH,'(A)') '3.2 inch 7.7 inch moveto'
      WRITE(LOUTCH,'(3A)') '(Flow for node ',TITLE(:L),') show'
      WRITE(LOUTCH,'(A)') '.1 inch setlinewidth'
      WRITE(LOUTCH,'(A)') '0.5 inch 0.5 inch moveto'
      WRITE(LOUTCH,'(A)') '7.5 inch 0.5 inch lineto'
      WRITE(LOUTCH,'(A)') '7.5 inch 7.5 inch lineto'
      WRITE(LOUTCH,'(A)') '0.5 inch 7.5 inch lineto'
      WRITE(LOUTCH,'(A)') 'closepath'
      WRITE(LOUTCH,'(A)') 'stroke'
      WRITE(LOUTCH,'(A)') '0.5 inch 0.5 inch translate'
      WRITE(LOUTCH,'(A)') '.01 inch setlinewidth'
      WRITE(LOUTCH,*) '/Helvetica-Bold findfont 8 scalefont setfont'
      RETURN
C
C ENTRY GRCLOSE
C
      ENTRY GRCLOSE
C! Close the graphics package
      WRITE(LOUTCH,'(A)') 'showpage grestore'
      END
