.TH flow 1 "16th July 1992"  "CERN"
.SH NAME
flow \- Fortran Structure Analysers 
.SH SYNOPSIS
.B flow 
[
.B \-l
] [
.B \-c common-text
] [
.B \-q
] [
.B \-n node
] [
.B \-s text-chart
] [
.B \-A Argument-chart
] [
.B \-g graphics-chart
] [
.B \-E
] [
.B \-i ignore-list
] [ file ]
.SH DESCRIPTION
.I Flow
is a companion tool to Floppy, which operates on a file produced
with the -t option of Floppy. Using Flow, one can generate various
reports which describe the structure of the original Fortran program
analysed by Floppy.
.SH PARAMETERS
The input 
.I file 
is a file of type .floptre produced by Floppy.
This file is easily created by using a Floppy command like:
.PP
floppy -t -cn myfile.f 
.PP
This file is a binary file, and cannot be viewed on the
terminal. It can only be processed by Flow. 
A Flow command to operate on the floptre file produced above 
might thus be:
.PP
flow -s myfile.f.floptre 
.PP
.SH OPTIONS
.IP \fB\-l\fR 12
The
.I logging
option causes Flow to produce a verbose description of the parsing
of the selected options.
.IP \fB\-c\ common-text \fR 12
The 
.I common
option creates a table containing procedure names on one axis, and
COMMON block names on the other, and indicates for each
procedure/COMMON intersection whether the COMMON block is
used or not in the procedure.  
.IP \fB\-E\fR 12
The
.I no Externals
option specifies that external routines are not to be included
in any output selected.
.IP \fB\-s\ text-chart\fR 12
The
.I structure-chart
option creates a file containing the calling tree of the source
program. Each SUBROUTINE, PROGRAM or FUNCTION in the 
source is a node in the calling tree. Each node is
displayed in the chart so that one can see a) which
other nodes call it, b) which nodes it calls, c) whether
the node is external, a stub, a subtree node, d) the
IF or DO level if the node is in an IF or DO clause.
.br
In addition, if the source FORTRAN contains a comment
line IMMEDIATELY after each procedure declaration, e.g.
.br
        SUBROUTINE INIJOB
  C! This subroutine initialises the job
.br 
(the ! sign is used as the trigger), then this comment is extracted
and put as a label to the node name in the structure chart.
.IP \fB\-A\ Argument-chart\fR 12
The
.I Argument-chart
option creates a file containing the names of all modules
in the source, and the types (if any) of their arguments.
Where another module makes a call with incorrectly declared
arguments to this module, then this is shown in the chart.
.IP \fB\-i\ ignore-list\fR 12
The
.I ignore
option specifies that, for the -s option, the given list
of module names are to be excluded from the calling tree output.
Specify the module names separated by commas, for example:
.br
-iFRED,BILL,HARRY,SUSAN
.IP \fB\-g graphics-chart\fR 12
The
.I graphics
option causes a picture file to be written, which may afterwards
be viewed using a PostScript previewer.
The picture file contains an approximate
representation of the equivalent SASD structure chart that
corresponds to the existing state of the Fortran code.
An effort is made to position the modules (SUBROUTINEs, 
FUNCTIONs, etc.) on the plot so that line crossing is 
minimised, but this is not always successful! 
.br
It is recommended to use the -E option together 
with the -g option: this helps to minimise the 
complexity of the plot.
.br
If the -n option has not been specified, then Flow will search
for the module that calls the most other modules, and use this
as the root of the tree.
.IP \fB\-n node\fR 12
The
.I node
option specifies the name of the module from which the tree
should begin. The node name given should thus correspond to
a module name in the source Fortran. 

.SH SEE ALSO
.PP
floppy(l), f77(1)
