      SUBROUTINE COMPAC(NUMBER)
*-----------------------------------------------------------------------
*
* extracts the FORTRAN field contents from the statement image.
*
*--- input
*    NUMBER          number of the statement to be extracted
*    SIMA            COMMON/ALCAZA/ (contains one complete routine)
*    NLTYPE,NFLINE,NLLINE,  COMMON/STATE/
*
*--- output
*    SSTA            COMMON/ALCAZA/  FORTRAN fields 7-72 of SIMA
*    NCHST           COMMON/STATE/  last non-blank in SSTA
*                    or =0 if statement consists of comment lines only
*    NLIMA, NLREF(1..NLIMA),   /STATE/
*
*
*-----------------------------------------------------------------------
      include 'param.h'
      include 'alcaza.h'
      include 'cursta.h'
      include 'state.h'
      NCHST=0
      NLIMA=0
*--- find last non-blank (only last line)
      JEND=LASTNB(SIMA(NLLINE(NUMBER)),8,72)
      DO 10 JLINE=NFLINE(NUMBER),NLLINE(NUMBER)
         IF (NLTYPE(JLINE).EQ.0) GOTO 10
         NLIMA=NLIMA+1
         NLREF(NLIMA)=JLINE
         IF (JLINE.EQ.NLLINE(NUMBER))  THEN
            JLAST=JEND
         ELSE
            JLAST=72
         ENDIF
         L=JLAST-6
         SSTA(NCHST+1:NCHST+L)=SIMA(JLINE)(7:JLAST)
         NCHST=NCHST+L
   10 CONTINUE
      END
