/* ******************************************************************** */
/*  slots.h          Copyright (C) Codemist and University of Bath 1989 */
/*                                                                      */
/* Slot/slot description manipulation	                                */
/* ******************************************************************** */

/*
 * Change Log:
 *   Version 1, December 1989
 */

#ifndef SLOTS_H
#define SLOTS_H

/* Slot description primitives */

extern LispObject Fn_slot_description_name(LispObject*);
extern LispObject Fn_slot_description_position(LispObject*);
extern LispObject Fn_slot_description_initargs(LispObject*);
extern LispObject Fn_slot_description_initform(LispObject*);

/* Weird abstractions... */

extern LispObject Fn_find_slot_description(LispObject*);
extern LispObject Fn_add_slot_description(LispObject*);

/* Initialiser */

extern void initialise_slots(LispObject*);

/* slot structure */

#define slot_desc_name(slot) slotref(slot,0)
#define slot_desc_position(slot) slotref(slot,1)
#define slot_desc_initargs(slot) slotref(slot,2)
#define slot_desc_initform(slot) slotref(slot,3)
#define slot_desc_mutable(slot) slotref(slot,4)

#define N_SLOTS_IN_SD_CLASS 5
#endif
