; map functions

(defmodule mapfuns

   ((except (mapc mapl maplist mapcon mapcar mapcan) standard0))

   ()

   (defcondition mapfn-error ())

   (defun mapfn-arg-error (name)
     (error "missing argument in map function" mapfn-error
	    'error-value name))

;   (defmethod (converter sexpr) ((p pair)) p)
;   (defmethod (converter sexpr) ((n empty-list)) n)

   ; fudge for lack of superclass of pair and ()
   (defmethod (converter pair) ((p pair)) p)
   (defconstant Null (class-of ()))
   (defmethod (converter pair) ((n Null)) ())
   (defmethod (converter pair) ((s string))
     (string2list s 0 (length s)))
   (defun string2list (s n len)
     (if (< n len)
	 (cons (string-ref s n) (string2list s (+ n 1) len))
	 ()))

   (defun listify (seq)
     (convert seq pair))

; l a list of lists
; ((a b c) (1 2) (A B C)) -> ((a 1 A) (b 2 B))

   (defun car-transpose (l)
     (let ((cars (get-cars l)))
       (if (atom cars) () (cons cars (car-transpose (get-cdrs l))))))

; ((a b c) (1 2) (A B C)) -> (((a b c) (1 2) (A B C)) ((b c) (2) (B C)))

   (defun cdr-transpose (l)
     (let ((cdrs (get-cdrs l)))
       (if (atom cdrs) () (cons l (cdr-transpose (get-cdrs l))))))

   (defun get-cars (l)
     (block exit
       (labels
	 ((get (ll)
	       (cond ((atom ll) ())
		     ((atom (car ll)) (exit ()))
		     (t (cons (caar ll) (get (cdr ll)))))))
	 (get l))))

   (defun get-cdrs (l)
     (block exit
       (labels
	((get (ll)
	      (cond ((atom ll) ())
		    ((atom (car ll)) (exit ()))
		    (t (cons (cdar ll) (get (cdr ll)))))))
	(get l))))

; mapc: apply fn to cars, return first list
   (defun mapc (fn . l)
     (let ((args (mapcar-1 listify l)))
       (cond ((atom args) (mapfn-arg-error 'mapc))
	     ((atom (cdr args)) (mapc-1 fn (car args)))
	     (t (mapc-n fn (car-transpose args))))
       (car l)))

   (defun mapc-1 (fn l)
     (if (atom l) ()
	 (progn (fn (car l)) (mapc-1 fn (cdr l)))))

   (defun mapc-n (fn l)
     (if (atom l) ()
	 (progn (apply fn (car l))
		(mapc-n fn (cdr l)))))

; mapl: apply fn to cdrs, return first list
   (defun mapl (fn . l)
     (let ((args (mapcar-1 listify l)))
       (cond ((atom args) (mapfn-arg-error 'mapl))
	     ((atom (cdr args)) (mapl-1 fn (car args)))
	     (t (mapl-n fn (cdr-transpose args))))
       (cdr l)))

   (defun mapl-1 (fn l)
     (if (atom l) ()
	 (progn (fn l) (mapl-1 fn (cdr l)))))

   (defun mapl-n (fn l)
     (if (atom l) ()
	 (progn (apply fn (car l))
		(mapl-n fn (cdr l)))))

; maplist: apply fn to cdrs, cons results
   (defun maplist (fn . l)
     (let ((args (mapcar-1 listify l)))
       (cond ((atom args) (mapfn-arg-error 'maplist))
	     ((atom (cdr args)) (maplist-1 fn (car args)))
	     (t (maplist-n fn (cdr-transpose args))))))

   (defun maplist-1 (fn l)
     (if (atom l) ()
	 (cons (fn l) (maplist-1 fn (cdr l)))))

   (defun maplist-n (fn l)
     (if (atom l) ()
	 (cons (apply fn (car l)) (maplist-n fn (cdr l)))))

; mapcon: apply fn to cdrs, nconc results
   (defun mapcon (fn . l)
     (let ((args (mapcar-1 listify l)))
       (cond ((atom args) (mapfn-arg-error 'mapcon))
	     ((atom (cdr args)) (mapcon-1 fn (car args)))
	     (t (mapcon-n fn (cdr-transpose args))))))

   (defun mapcon-1 (fn l)
     (if (atom l) ()
	 (nconc (fn l) (mapcon-1 fn (cdr l)))))

   (defun mapcon-n (fn l)
     (if (atom l) ()
	 (nconc (apply fn (car l)) (mapcon-n fn (cdr l)))))

; mapcar: apply fn to cars, cons results
   (defun mapcar (fn . l)
     (let ((args (mapcar-1 listify l)))
       (cond ((atom args) (mapfn-arg-error 'mapcar))
	     ((atom (cdr args)) (mapcar-1 fn (car args)))
	     (t (mapcar-n fn (car-transpose args))))))

   (defun mapcar-1 (fn l)
     (if (atom l) ()
	 (cons (fn (car l)) (mapcar-1 fn (cdr l)))))

   (defun mapcar-n (fn l)
     (if (atom l) ()
	 (cons (apply fn (car l)) (mapcar-n fn (cdr l)))))

; mapcan: apply fn to cars, nconc results
   (defun mapcan (fn . l)
     (let ((args (mapcar-1 listify l)))
       (cond ((atom args) (mapfn-arg-error 'mapcan))
	     ((atom (cdr args)) (mapcan-1 fn (car args)))
	     (t (mapcan-n fn (car-transpose args))))))

   (defun mapcan-1 (fn l)
     (if (atom l) ()
	 (nconc (fn (car l)) (mapcan-1 fn (cdr l)))))

   (defun mapcan-n (fn l)
     (if (atom l) ()
	 (nconc (apply fn (car l)) (mapcan-n fn (cdr l)))))

;   (export mapcar mapcon maplist mapl mapc mapcan)
   (export mapcon maplist mapl mapcan)

)
