;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;   EuLisp Module  -   Copyright (C) Codemist and University of Bath 1989   ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;; Name: linda-tables                                                        ;;
;;                                                                           ;;
;; Author: Keith Playford                                                    ;;
;;                                                                           ;;
;; Date: 31 May 1990                                                         ;;
;;                                                                           ;;
;; Description: Basic IO for linda pool tuple spaces                         ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;

;; Change Log:
;;   Version 1.0 (31/5/90)

;;

(defmodule linda-tabs

  (lists
   list-operators
   extras
   arith
   classes
   streams
   ccc
   tables
   vectors
   calls
   others

   linda-base) ()


  ;;

  ;; Note:

  ;;   Just a hack to begin with - going for an eq on name and equal on 
  ;;   everything else to fit in with Dave's world of tuple vectors.

  ;;

  ;; Tuple table structure...

  (defstruct linda-tuple-table ()
    ((table initform (make-table eq)
	    accessor tuple-table-table))
    constructor make-linda-tuple-table)

  (export make-linda-tuple-table tuple-table-table)

  ;; Interface...

  (defun tuple-table-out (tuple-table tuple)
    (let* ((tab (tuple-table-table tuple-table))
	   (key (linda-tuple-key tuple))
	   (set (table-ref tab key)))
      ((setter table-ref) tab key (nconc set (list tuple)))
      tuple))

  ;; Match from a set...

  (defun in-match-from (tuple ll)
    (in-match-from-aux tuple ll nil))

  (defun in-match-from-aux (tuple ll prev)
    (cond 
      ((null ll) nil)
      ((null (car ll)) (in-match-from-aux tuple (cdr ll) ll))
      ((linda-tuple-matched-p tuple (car ll)) 
        (let ((match (car ll)))
	  (if (null prev) 
	    ((setter car) ll nil)
	    ((setter cdr) prev (cdr ll)))
	   match))
      (t (in-match-from-aux tuple (cdr ll) ll))))

  (defun tuple-table-in (tuple-table tuple)
    (let* ((tab (tuple-table-table tuple-table))
	   (key (linda-tuple-key tuple))
	   (set (table-ref tab key)) ;; Assumes key can't be wildcard
	   (match (in-match-from tuple set)))
      match))

  (defun read-match-from (tuple ll)
    (cond 
      ((null ll) nil)
      ((null (car ll)) (read-match-from tuple (cdr ll)))
      ((linda-tuple-matched-p tuple (car ll)) (car ll)) ;; Copy?
      (t (read-match-from tuple (cdr ll)))))

  (defun tuple-table-read (tuple-table tuple)
    (let* ((tab (tuple-table-table tuple-table))
	   (key (linda-tuple-key tuple))
	   (set (table-ref tab key)) ;; Assumes key can't be wildcard
	   (match (read-match-from tuple set)))
      match))

  (export tuple-table-in tuple-table-read tuple-table-out)

)
