;; Eulisp Module
;; Author: pete broadbery
;; File: pvm-start.em
;; Date: 20/may/1991
;;
;; Project:
;; Description: 
;; starts up a group of pvm clients
;;

(defmodule pvm-start 
  (standard0
   list-fns
   pvm-client
   pvm-msgs
   pvm-support
   pvm
   )
  ()
  

  ;; structures
  (defstruct Client-Description ()
    ((host initarg host reader CD-host)
     (path initarg path initform () reader CD-path)
     (module initarg module initform module reader CD-module)
     (executable initform (default-pvm-name)
		 initarg executable
		 reader CD-executable)
     (function initarg function reader CD-function)
     (arg initarg arg reader CD-arg))
    constructor make-Client-Description)

  (export make-Client-Description Client-Description)
  ;;
  ;; low-level startup
  ;;

  (deflocal *test* nil)
  (defun initialise-pvm ()
    (setq *test* t)
    (start-local-pvm))

  (defun start-pvm-process (sponsor cd)
    (if (not *test*)
	nil
      (let ((new-obj (pvm-initiate-by-hostname (CD-host cd) 
					       (CD-executable cd))))
	(pvm-set-load-path new-obj (CD-path cd))
	(pvm-start new-obj
		   (CD-module cd)
		   (CD-function cd) 
		   (CD-arg cd))
	(initiate-client sponsor new-obj)
	new-obj)))

  (defun make-pvm-client (class type . ia)
    (let ((client (make-local-client class
				     (nconc (list 'type type)
					    ia))))
      client))
			     
  (export make-pvm-client start-pvm-process initialise-pvm)
  ;; end module
  )
