(defmodule takfut
	(standard0 list-fns fut2)
  ()
(defun tak1 (x y z)
  (if (not (< (dist-future-value y) 
	      (dist-future-value x)))
      z
      (dist-future tak1
		   (tak1 (- (dist-future-value x) 1) y z)
		   (tak1 (- (dist-future-value y) 1) z x)
		   (tak1 (- (dist-future-value z) 1) x y))))

(defun tak (x y z)
  (if (not (< (dist-future-value y) 
	(dist-future-value x)))
      z
      (tak
	(dist-future tak (- (dist-future-value x) 1) y z)
	(dist-future tak (- (dist-future-value y) 1) z x)
	(dist-future tak (- (dist-future-value z) 1) x y))))

(defun tak2 (x y z)
  (format t "Tak2: ~a ~a ~a~%" x y z)
  (if (not (< (dist-future-value y)
	      (dist-future-value x)))
      z
      (let ((a1 (dist-future tak2 (- (dist-future-value x) 1) y z))
	    (a2 (dist-future tak2 (- (dist-future-value y) 1) z x))
	    (a3 (dist-future tak2 (- (dist-future-value z) 1) x y)))
	(tak2 (dist-future-value a1)
	      (dist-future-value a2)
	      (dist-future-value a3)))))

(define-future-fun 'tak1 tak1)
(define-future-fun 'tak tak)
(define-future-fun 'tak2 tak2)

(defun test () (tak 6 12 9))

(defun fut-fun (x) x)

(defun ret-fut ()
  (dist-future fut-fun 10))

(defun f-v (x)
  (dist-future-value x))

(define-future-fun 'fut-fn fut-fun)
(define-future-fun 'ret-fut ret-fut)
(define-future-fun 'f-v f-v)

(defun doit () (dist-future f-v (dist-future ret-fut)))
(define-future-fun 'doit doit)
(deflocal hosts '(mul))

((setter future-threshold) 3)
(defun startup ()
  ;; load-path , start-module, server rest
  (setq procs (initialise-network '("DVSM") 'takfut task-server (car hosts) (cdr hosts))))
  
(defun map-procs (fn args)
  (let ((procs (mapcar (lambda (x) (make-dist-future x fn args))
		       procs)))
    (mapcar dist-future-value procs)))

)
\end{verbatim}
\subsubsection{ Future in the outer call to tak}
\begin{verbatim}
(defun tak2 (x y z)
  (if (not (< (future-value y) (future-value x)))
      z
      (future (tak2
                (tak2 (- (future-value x) 1) y z)
                (tak2 (- (future-value y) 1) z x)
                (tak2 (- (future-value z) 1) x y)
              )
      )
  )
)
\end{verbatim}
\subsubsection{ Futures in both places}
\begin{verbatim}
(defun tak3 (x y z)
  (if (not (< (future-value y) (future-value x)))
      z
      (future (tak3
                (future (tak3 (- (future-value x) 1) y z))
                (future (tak3 (- (future-value y) 1) z x))
                (future (tak3 (- (future-value z) 1) x y))
              )
      )
  )
)
\end{verbatim}
