;; objects for storing things

(defmodule objects 
   (standard0
    list-fns
    scan-args

    page
    page-mapper
    allocator
    )

   ()

   (defclass obj-class (class)
     ((n-slots initform 0
	       accessor obj-class-n-slots)
      (allocator initform (make-null-allocator)
		 initarg allocator
		 accessor obj-class-allocator))
     )
   
   (defun allocator-of (class)
     (if (null-allocator-p (obj-class-allocator class))
	 (allocator-of (car (cdr (class-precedence-list class))))
       (obj-class-allocator class)))
   
   ((setter setter) allocator-of (setter obj-class-allocator))
   ;; new slot-descrition class
   (defclass obj-slot-description (slot-description)
    ()
    predicate is-obj-slot
    metaclass slot-description-class)
  
  (defmethod add-slot-description ((ecl obj-class) (esd obj-slot-description))
    ((setter slot-description-position) esd (obj-class-n-slots ecl))
    (call-next-method)
    ((setter obj-class-n-slots) ecl 
     (+ (obj-class-n-slots ecl) 1)))

  (defconstant *old-sym* '%__new__%)

  (defun obj-new-p (lst)
    (scan-args *old-sym* lst ()))
  
  (defclass obj-object (object)
    ((address accessor obj-address))
    metaclass obj-class)

  (defmethod allocate-instance ((oclass obj-class) lst)
    (let ((new (call-next-method))
	  (res (obj-new-p lst)))
      (if (not res)
	  ((setter obj-address) new 
	   (allocate-space (allocator-of oclass) 
			   (obj-class-n-slots oclass)
			   oclass))
	((setter obj-address) new res))
      new))

  (defmethod slot-value-using-slot-description ((obj obj-object) 
						(esd obj-slot-description))
    (external-rep (address-ref (internal-rep obj)
			       (slot-description-position esd))))

  (defmethod (setter slot-value-using-slot-description) 
      ((obj obj-object) (esd obj-slot-description) value)
    (external-rep ((setter address-ref)
		   (internal-rep obj)
		   (slot-description-position esd)
		   (internal-rep value))))
  
   (export obj-class allocator-of  obj-slot-description is-obj-slot obj-object)
	   
  ;; Object representations
  ;; unfortunately, to create an object, we need its class, so we dump this in the
  ;; address record. really would like a better hack

  (defmethod internal-rep ((x obj-object))
    (obj-address x))

  (defmethod external-rep ((x address))
    (make-instance (address-class x)
		   'address x))

  ;; should be a little fussier.
  (defmethod internal-rep ((x object))
    x)

  (defmethod external-rep ((x object)) 
    x)

)
	

