(defmodule fut-serv
   (standard0
    list-fns

    low-fut
    pvm-support

    reader
    genread
    threads
    )
  ()
  
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; server
  ;;


  (defstruct task-pool ()
	     ((clients initarg clients accessor task-pool-clients)
	      (tasks initform () accessor task-pool-tasks)
	      (waiters initform () accessor task-pool-waiters)
	      ;; list of task-ids that have passed through
	      (tsk-list initform ()
			accessor server-proxy-waits)
	      (located-tasks initform () accessor task-pool-located-tasks))
	     constructor (make-task-pool clients))
  
  ;; generics on adding new tasks +c.
  (defgeneric note-new-task (pool)
    methods ((((o object)) nil)))
  
  (defgeneric note-alloc-task (pool)
    methods ((((o object)) nil)))
  
  ;; server functions:
  ;;
  ;; server-loop
  ;; add-new-task
  ;; get-next-task
  
  ;; NB. This is all supposed to be atomic...
  (defstruct proxy-task ()
    ((id initarg id reader proxy-task-id)
     (host initarg host reader proxy-task-host)
     (value initform 'ugh 
	    accessor proxy-task-value))
    constructor (make-proxy-waiter host id))

  (defun remote-start-server ()
    (let ((pool (make-task-pool ())))
      (initialise-reader pool)
      (print (default-reader))
      (with-handler  
       (lambda (c1 c2)
	 ;;(rshow c1)
	 (format t "Error Message: ~a~%Error Value: ~a~%" 
		 (condition-message c1)
		 (condition-error-value c1))
	 (flush (standard-output-stream))
	 (flush (standard-error-stream))
	 ;;(backtrace)
	 nil)
       (server-loop pool))))

  (defconstant server-dispatcher (mk-finder))

  (defun server-loop (server)
    (let ((msg (pvm-recv-multi (list *server-msg* *proxy-msg*) t
			       (default-reader))))
      (cond ((eq (caddr msg) *server-msg*)
	     (format t "Server: got ~a~%" (car msg))
	     ((server-dispatcher (car (car msg)))
	      server (cdr (car msg)))
	     (server-loop server))
	    ((eq (caddr msg) *proxy-msg*)
	     (handle-proxy-result server (car msg))
	     (server-loop server)))))
  

  ;; waiters: FIFI
  ;; tasks: FILO
  (defun server-add-new-task (pool task)
    (format t "Add task: ~a~%" task)
    (let ((real-task (car task)))
      (if (not (equal (car (cdddr real-task)) -1))
	  (add-located-task pool real-task (car (cdddr real-task)))
	(if (null (task-pool-waiters pool))
	    (progn (note-new-task pool)
		   ((setter task-pool-tasks) pool 
		    (cons real-task (task-pool-tasks pool))))
	  (let ((nxt (car (t-val (task-pool-waiters pool)))))
	    ((setter task-pool-waiters) pool
	     (t-cdr (task-pool-waiters pool)))
	    (format t "Server: sending [~a] ~a~%" nxt real-task)
	    (pvm-send nxt
		      *client-msg*
		      (list 'task real-task)
		      (add-writers (default-reader) pool
				   nxt)))))))

  (defun add-located-task (pool task loc)
    (if (not (member loc (t-val (task-pool-waiters pool)) equal))
	(let ((xx (assoc loc (task-pool-located-tasks pool) equal)))
	  (if (null xx)
	      ((setter task-pool-located-tasks) pool 
	       (cons (cons loc (list task))
		     (task-pool-located-tasks pool)))
	    (nconc xx (list task)))
	  nil)
      (progn ((setter task-pool-waiters) pool 
	      (t-append () 
			(delete loc (t-val (task-pool-waiters pool)) equal)))
	     (format t "Sending Task~%")
	     ;;(rshow pool)
	     (pvm-send loc 
		       *client-msg*
		       (list 'task task)
		       (add-writers (default-reader) pool
				    loc)))))



  (defun server-get-next-task (pool where)
    (format t "get next: ~a~%" where)
    (let ((t-list (assoc (car where) (task-pool-located-tasks pool) equal)))
      (if (or (null t-list)
	      (null (cdr t-list)))
	  (if (null (task-pool-tasks pool))
	      ((setter task-pool-waiters) pool 
	       (tconc (task-pool-waiters pool)
		      (car where)))
	    (let ((nxt (car (task-pool-tasks pool))))
	      ((setter task-pool-tasks) pool
	       (cdr (task-pool-tasks pool)))
	      (note-alloc-task pool)
	      (format t "Server: sending [~a] ~a~%" (car where) nxt)
	      (pvm-send (car where)
			*client-msg*
			(list 'task nxt)
			(add-writers (default-reader) pool
				     (car where)))))
	(let ((task (cadr t-list)))
	  ((setter cdr) t-list
	   (cdr (cdr t-list)))
	  (pvm-send (car where)
		    *client-msg*
		    (list 'task task)
		    (add-writers (default-reader) pool
				 (car where)))))))

  
  ;; proxy hackery....
  ;; should read both proxys and tasks

  (defconstant make-proxy-id (mk-counter 600))

  (defun server-read-proxy (pool)
    (lambda (value reader)
      (let ((xx (read-next value reader)))
	(if (eq xx 'ugh)
	    (let* ((host (read-next value reader))
		   (id (read-next value reader)))
	      (make-new-proxy-waiter pool host id)
	      (make-proxy-waiter host id))
	    xx))))

  (defun mk-proxy-write (server host)
    (lambda (proxy value reader)
      (let ((xx (peek-proxy-value server proxy)))
	(if (eq (car xx) 'ok)
	    (write-next (cdr xx) value reader)
	    (let ((next-id (make-proxy-id)))
	      (register-proxy-callback server
				       (proxy-task-host proxy)
				       (proxy-task-id proxy)
				       host next-id)
	      (write-next 'ugh value reader)
	      (write-next (pvm-whoami) value reader)
	      (write-next next-id value reader))))))

  (defun peek-proxy-value (server task)
    (if (eq (proxy-task-value task) 'ugh)
	(let* ((val (assoc (proxy-task-id task)
			   (cdr (assoc (proxy-task-host task)
				  (server-proxy-waits server)
				  equal))
			   =)))
	  (if (eq (cadr val) 'undone)
	      '(())
	      (cons 'ok (cadr val))))
	(cons 'ok (proxy-task-value task))))
  ;;
  ;; Sending and recieving remote-task-objects
  ;;

  ;; adding to a uncompleted-future's list of things to do...
  
  (defun register-proxy-callback (server proxy-host proxy-id tohost id)
    (add-proxy-callback (assoc proxy-id 
			       (cdr (assoc proxy-host (server-proxy-waits server) equal))
			       =)
			tohost id))

  (defun add-proxy-callback (lst tohost id)
    (nconc lst (list (cons tohost id))))
    
  ;; and using the info 
  (defun send-proxies (res server)
    (lambda (proxy-id)
      (format t "sending to: ~a~%" proxy-id)
      (pvm-send (car proxy-id)
		*proxy-msg*
		(list (pvm-whoami)
		      (cdr proxy-id) res)
		(add-writers (default-reader) server (car proxy-id)))))
  
  ;; when we get a *proxy-msg*
  
  (defun handle-proxy-result (server msg)
    (let ((host (car msg))
	  (id (cadr msg))
	  (res (caddr msg)))
      (format t "Proxy result: (~a,~a) ~a~%" id host res)
      (add-result-aux server 
		      (cdr (assoc host (server-proxy-waits server) equal))
		      id res)))
  
  ;; add a new object
  (defun add-result-aux (server lst id res)
    (let ((obj (assoc id lst =)))
      (if (or (null lst) (null obj)) (error "oh heck" clock-tick) ())
      (format t "add-result: ~a ~a~%" id res)
      ;; note that it has been done
      ((setter car) (cdr obj) res)
      (mapc (send-proxies res server)
	    (cddr obj))
      nil))

  ;; when we rcv a new proxy
  (defun make-new-proxy-waiter (server host id)
    (let ((xx (assoc host (server-proxy-waits server) equal)))
      ;; install into wait-list
      (if xx 
	  ((setter cdr) xx (cons (list id 'undone) (cdr xx)))
	  ((setter server-proxy-waits) server 
	   (cons (list host (list id 'undone) '(-1 ()))
		 (server-proxy-waits server))))
      nil))


  ;; should be in list-fns...

  (defun tconc (ptr elem)
    (let ((new-pair (list elem)))
      (cond ((null ptr)
	     (cons new-pair new-pair))
	    (t
	     ((setter cdr) (cdr ptr) new-pair)
	     ((setter cdr) ptr new-pair)
	     ptr))))

  (defun t-cdr (x)
    (if (null x)
	(error "oops" clock-tick)
	(if (null (cdr (car x)))
	    ()
	    (cons (cdr (car x)) (cdr x)))))

  (defun t-val (x)
    (if (null x) x (car x)))

  (defun t-append (x list)
    (cond ((and (null x)
		(null list))
	   nil)
	  ((null x)
	   (cons list
		 (last-pair list)))
	  ((null list)
	   x)
	  (t ((setter cdr) (cdr x) list)
	     ((setter cdr) x (last-pair list))
	     x)))

  ((setter server-dispatcher) 'add-task server-add-new-task)
  ((setter server-dispatcher) 'task-request server-get-next-task)

  (defun add-writers (writer server host)
    (add-writer writer proxy-task *task-object*
		(mk-proxy-write server host))
    writer)

  (defun initialise-reader (server)
    (add-reader (default-reader) 
		*task-object* 
		(server-read-proxy server))
    (add-reader (default-reader)
		*function-object*
		fake-function-reader)
    (add-writer (default-reader)
		function-struct
		*function-object*
		fake-function-writer))

  ;; reading hacks
  (deflocal *reader*     (make-obj-reader))
  (defun default-reader ()
    *reader*)

  ((setter setter) default-reader
   (lambda (reader)
     (setq *reader* reader)))
  
  (export default-reader)

  (export remote-start-server)
  ;; close module
  )
