/* Numbers for instruction set. 
   Used by instruct.em and bytecodes.h
   */

#define BC_NOP 0
	  
	  /* Globals  etc */
#define BC_PUSH_GLOBAL 1 
#define BC_SET_GLOBAL 2

#define BC_PUSH_SPECIAL 3
#define BC_PUSH_STATIC  4
#define BC_PUSH_FIXNUM 5
#define BC_SET_STATIC  6

	  /* stack refs */
#define BC_PUSH_NTH 7
#define BC_SET_NTH 8
	  
	  /* Stack abuse */
#define BC_SLIDE_STACK 9
#define BC_SWAP        10
#define BC_DROP 	11
	  
	  /* env reference */
#define BC_ENV_REF 	12
#define BC_SET_ENV 	13
#define BC_POP_ENV 	14
#define BC_MAKE_ENV 	15

	  /* object reference */
#define BC_VREF 	16
#define BC_SET_VREF 	17

#define BC_SLOT_REF 	18
#define BC_SET_SLOT 	19

#define BC_SET_TYPE 	20

	  /* Leaping merrily */
#define BC_BRANCH 	21
#define BC_BRANCH_NIL 	22

	  /* Calling things */
#define BC_APPLY_ANY 		23
#define BC_APPLY_BVF 		24
#define BC_APPLY_METHODS 	25
#define BC_PUSH_LABEL 	26
	  
	  /* and return */
#define BC_RETURN 	27

#define BC_EXIT 	28

/* allocation */	
#define BC_CONS 	29
#define BC_ALLOC_CLOSURE 30
#define BC_PUSH_INT 	31

/* Tests */
#define BC_NULLP 32
#define BC_EQP 	33
#define BC_ARG_CHECK 34

/* Reflection */
#define BC_CONTEXT	35
#define BC_ENSURE_STACK 36
/* Inline method list */

/* Arithmetic */
#define METHOD_INT_ADD 		0
#define METHOD_INT_DIFF		1
#define METHOD_INT_MULT		2
#define METHOD_INT_DIV		3
#define METHOD_INT_EQUAL	4

/* Stream primitives */
#define METHOD_STREAM_WRITE	5
#define METHOD_STREAM_READ	6
