/* ******************************************************************** */
/*  defs.h           Copyright (C) Codemist and University of Bath 1989 */
/*                                                                      */
/* Basic definitions of tags and structures                             */
/* ******************************************************************** */

/*
 * Change Log:
 *   Version 1, April 1989
 */

#ifndef DEFS_H
#define DEFS_H

#ifndef TRUE
#define TRUE	(1)
#define FALSE 	(0)
#endif

#define CONTINUABLE	(2)
#define NONCONTINUABLE	(3)

#define STUB(name) printf("*** stub %s called\n", name)

#define IGNORE(name)	(name = name)

#ifdef MACHINE_SYSTEMV
#define MAX_PROCESSORS (10)
#endif

#ifdef MACHINE_BSD
#define MAX_PROCESSORS (1)
#endif

#ifdef MACHINE_ANY
#define MAX_PROCESSORS (1)
#endif

#ifndef BYTE_ALIGNMENT
#define BYTE_ALIGNMENT (8)
#endif

#define RESET_GLOBAL_STACK() /** GC_STACK_POINTER() = stacktop**/

#endif /* DEFS_H */
/* End of defs.h */
