;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule xphil

  (lists
   list-operators
   extras
   streams
   arith
   others

   linda-base
   linda-tabs
   linda
   vectors
   threads
   semaphores

   driver) ()

  ;; Graphics...

  (plot-string X-stream 155 495 "Dining Philosophers in Linda")

  (read-pixmap X-stream "phil.xbm") ;; Philosopher
  (read-pixmap X-stream "thinks.xbm") ;; Idea
  (read-pixmap X-stream "sticks.xbm") ;; Chops
  (read-pixmap X-stream "ticket.xbm") 
  (read-pixmap X-stream "bulb.xbm") 

  (deflocal *think-level* 360)
  (deflocal *eat-level* 140)
  (deflocal *margin* 50)
  (deflocal *space* 80)

  ;; Our linda pool...

  (deflocal phil-pool (make-linda-pool))

  ;; Parameter...

  (deflocal Num 6)

  ;; Philosopher process...

  (defun phil (i)
    (tilnil
      (linda-in phil-pool (tuple 'room-ticket))
      (unplot X-stream 1 (+ *margin* (* i *space*)) (- *think-level* 40))
      (plot X-stream 4 (+ *margin* (* i *space*)) (- *think-level* 40))
      (unplot X-stream 4 (+ *margin* (* i *space*)) (- *think-level* 40))
      (plot X-stream 3 (+ *margin* (* i *space*)) (+ *eat-level* 40))
      (move X-stream i (+ *margin* (* i *space*)) *eat-level*)
      (linda-in phil-pool (tuple 'chopstick i))
      (linda-in phil-pool (tuple 'chopstick (remainder (+ i 1) Num)))
      (plot X-stream 2 (+ *margin* (* i *space*)) (- *eat-level* 40))
      (linda-out phil-pool (tuple 'chopstick i))
      (linda-out phil-pool (tuple 'chopstick (remainder (+ i 1) Num)))
      (unplot X-stream 2 (+ *margin* (* i *space*)) (- *eat-level* 40))
      (linda-out phil-pool (tuple 'room-ticket))
      (unplot X-stream 3 (+ *margin* (* i *space*)) (+ *eat-level* 40))
      (move X-stream i (+ *margin* (* i *space*)) *think-level*)
      (plot X-stream 1 (+ *margin* (* i *space*)) (- *think-level* 40))
      t))
  
  (defun init () (init-aux Num))

  (defun init-aux (n)
    (if (= n 0) 
      (progn
	(prin "init complete for ") (prin Num) (print " philosophers")
;;	(linda-in phil-pool (tuple 'zombie))
	(thread-suspend))
      (progn
	(linda-out phil-pool (tuple 'chopstick (- n 1)))
	(manage X-stream 0)
	(move X-stream (- Num n) (+ *margin* (* (- Num n) *space*))
	      *think-level*)
	(plot X-stream 1 (+ *margin* (* (- Num n) *space*)) 
	      (- *think-level* 40))
;;	(plot X-stream 0 (+ *margin* (* (- Num n) *space*)) *think-level*)
	(prin "phil ") (prin (- n 1))
	(prin " is ") (print (linda-start phil (- Num n)))
	(if (< (- n 1) (- Num 1)) 
	  (linda-out phil-pool (tuple 'room-ticket))
	  nil)
	(init-aux (- n 1)))))

  (defun doit () (linda-start init) (linda-scheduler))

  (doit)

)
	
    
    
