;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; make makefile dependencies
; RJB Initial version Feb 91.
;
; RJB Rename unionq to remove-repetitions 13 Mar 91

(defmodule eumake (standard)

  ()

  ; (MD 'foo '(bar baz wop)) will make a makefile for target foo using the
  ; modules bar.em, baz.em and wop.em
  (defun MD (name mods)
    (let* ((deplists (mapcar module-depends mods))
	   (modlist (nreverse (tsort
		     (mapcan (lambda (x)
			       (mapcar (lambda (y) (cons (car x) y))
				       (cdr x)))
			     deplists)))))
      (format t ".SUFFIXES:~%.SUFFIXES: .em .o~%~%")
      (format t "EU2C = eu2c~%")
      (format t "ECC  = ecc~%~%")
      (format t ".em.o:~%~t$(EU2C) $*~%~t$(ECC) -c $*.c~%")
      (format t "~trm -f $*.c $*.xm~%~%")
      (format t "# The order of these is important -- do not change!~%")
      (format t "SRCS =")
      (mapc (lambda (mod)
	      (when (memq mod mods) (format t " ~a.em" mod)))
	    modlist)
      (format t "~%~%OBJS =")
      (mapc (lambda (mod)
              (when (memq mod mods) (format t " ~a.o" mod)))
	      modlist)
      (format t "~%~%~a: $(OBJS)" name)
      (format t "~%~t$(ECC) -o ~a $(OBJS)~%~%" name)
      (mapc (lambda (deplist)
	      (format t "~a.o:" (car deplist))
	      (mapc (lambda (dep)
		      (when (memq dep mods)
			    (format t " ~a.o" dep)))
		    (cdr deplist))
	      (format t "~%"))
	    deplists)
      (format t "~%clean:~%~trm -f *.c *.o *.i *.xm ~a~%" name)))

  (defun name-to-file (filename)
    (unless (stringp filename)
	    (setq filename (symbol-name filename)))
    (let ((len (string-length filename)))
    (if (and (> len 3)
	    (equal (string-slice filename (- len 3) (- len 1)) ".em"))
	filename
        (string-append filename ".em"))))

  ; given a module name, return a list
  ; (name . modules it depends on)
  (defun module-depends (filename)
    (let* ((fn (open (name-to-file filename) 'input))
	   (spec (caddr (read fn))))
      (close fn)
      (cons filename (remove-repetitions (do-spec spec)))))

  (defconstant stderr (standard-error-stream))

  (defun do-spec (spec)
    (if (atom spec) (list spec)
      (let ((directive (car spec)))
	(when (memq directive '(expose union)) (old-spec directive))
	(cond ((eq directive 'expose) (cdr spec))
	      ((memq directive '(except only rename))
	       (if (or (atom (cdr spec))
		       (atom (cddr spec))) (dodgy-spec spec)
		 (mapcan do-spec (cddr spec))))
	      ((eq directive 'union)
	       (if (atom (cdr spec)) (dodgy-spec spec)
		 (mapcan do-spec (cdr spec))))
	      (t (mapcan do-spec spec))))))

  (defun old-spec (spec)
    (format stderr "*** old style spec ~a~%" spec))

  (defun dodgy-spec (spec)
    (format stderr "*** dodgy spec ~a~%" spec))

  (defun remove-repetitions u
    (if (atom u) ()
        (let ((table (make-table eq)))
	  (mapc (lambda (l)
		  (if (atom l) ()
		      (mapc (lambda (e) ((setter table-ref) table e t)) l)))
		u)
	  (table-keys table))))

  (defun set-diffq (a b)
    (mapcan (lambda (elt) (if (memq elt b) () (list elt))) a))

  ; takes a list of ( (obj1 . obj2) ... )
  ; which means obj1 > obj2
  ; return a lists of objs with largest first
  (defun tsort (pairlist)
    (if (atom pairlist) ()
       (let* ((firsts (remove-repetitions (mapcar car pairlist)))
	      (lasts  (remove-repetitions (mapcar cdr pairlist)))
	      (only-firsts (set-diffq firsts lasts)))

	 (when (null only-firsts)
	       (error "loop in tsort pairs" Internal-Error))

	 (setq pairlist
	       (mapcan (lambda (apair)
			 (if (memq (car apair) only-firsts)
			     ()
                             (list apair)))
		       pairlist))

	 (nconc only-firsts
		(nconc (tsort pairlist)
		       (set-diffq lasts
			  (remove-repetitions (mapcar car pairlist)
					      (mapcar cdr pairlist))))))))

)
