;; Eulisp Module
;; Author: pab
;; File: bitvecs.em
;; Date: Tue Apr 28 11:00:02 1992
;;
;; Project:
;; Description: 
;;

(defmodule bitvecs
  (standard0
   bit-vectors
   )
  ()
  
  (defstruct bit-vector ()
    ((str initarg str accessor bit-vector-str))
    constructor (make-bit-vector size)
    predicate bit-vector-p)

  (defmethod initialize-instance ((proto bit-vector) lst)
    (let ((obj (call-next-method))
	  (size (car (cdr lst))))
      ((setter bit-vector-str) obj (primitive-make-bit-vector size))
      obj))

  (defun bit-vector-ref (bv n)
    (primitive-bit-vector-ref (bit-vector-str bv) n))

  (defun bit-vector-ref-setter (bv n x)
    ((setter primitive-bit-vector-ref) (bit-vector-str bv) n x)
    x)

  ((setter setter) bit-vector-ref bit-vector-ref-setter)

  (defmethod generic-prin ((x bit-vector) stream)
    (generic_generic_prin\,BitVector (bit-vector-str x) stream))

  (export bit-vector-ref bit-vector-ref-setter bit-vector make-bit-vector)
      
     
  ;; end module
  )
