;; Eulisp Module
;; Author: pete broadbery
;; File: pvm-support.em
;; Date: 9/jul/1991
;;
;; Project:
;; Description: 
;;  rehacked version of pvm-support code
;;

(defmodule pvm-support 
  (standard0
   list-fns
   module-operators
   pvm-req
   pvm
   )
  ()
  
;;n  (defun pvm-recv (x y . z)
;;    (format t "Recv: ~a ~a ~a\n" x y)
;;    (print (apply real-pvm-recv x y z)))

;;  (defun pvm-send (x y . z)
;;    (format t "Send: ~a ~a ~a\n" x y)
;;    (print (apply real-pvm-send x y z)))

;;  (defun pvm-enroll (name)
;;    (format t "Enroll: ~a\n" name)
;;    (real-pvm-enroll name))

  (expose pvm)
  (expose pvm-req)
  (export pvm-recv pvm-send pvm-enroll)
  ;; The one true requester

  (defconstant *request-ob* (make-pvm-waiter))

  (defun std-pvm-waiter ()
    *request-ob*)

  ;; table of functions

  (defconstant pvm-function (mk-finder))
  (defconstant *std-pvm-name* "pvm-feel")

  (defun default-pvm-name ()  *std-pvm-name*)
   
  (defconstant *pvm-msg-type* 10)
  ;; the startup function

  (defun pvm-begin ()
    (with-handler (lambda (c1 c2)
		    (format t "Shutting down after an error")
		    (format t "Error Message: ~a~%Error Value: ~a~%" 
			    (condition-message c1)
			    (condition-error-value c1))
		    (flush (standard-output-stream))
		    (backtrace)
		    (flush (standard-output-stream))
		    (pvm-leave))
	   (pvm-enroll *std-pvm-name*)
	   (start-pvm-waiter (std-pvm-waiter))
	   (handle-pvm-messages)))

  (defun read-msg ()
    (add-pvm-waiter (std-pvm-waiter) 
		    (current-thread)
		    *pvm-msg-type*)
    (thread-suspend)
    (pvm-recv *pvm-msg-type* ()))

  (defun handle-pvm-messages ()
    (let ((msg (read-msg)))
      (format t "low: got ~a~%" msg)
      ((pvm-function (car msg)) (cdr msg)))
    (handle-pvm-messages))

  ;; local start
  (defun start-local-pvm ()
    (pvm-enroll *std-pvm-name*)
    (start-pvm-waiter (std-pvm-waiter))
    (thread-start (make-thread handle-pvm-messages)))
  

    ;; methods...
  ((setter pvm-function) '%load-path
   (lambda (msg)
     ((dynamic-access (get-module 'root) 'set-load-path)
      (append (mapcar hack-path msg) 
	      ((dynamic-access (get-module 'root) 'load-path))))))

  (defun hack-path (path)
    (cond ((equal (substring path 0 0) "/") path)
	  (t (format nil "~a/~a" (getenv "HOME") path))))

  ((setter pvm-function) '%leave
   (lambda (msg)
     (format t "Shutting down gracelessly")
     (flush (standard-output-stream))
     (flush (standard-error-stream))
     (pvm-leave)
     (exit)))

  ((setter pvm-function) '%start
   (lambda (msg)
     (apply (dynamic-access (dynamic-load-module (car msg))
			    (cadr msg))
	    (caddr msg))))

;; driver functions
  (defun pvm-set-load-path (who path)
    (pvm-send who *pvm-msg-type* (cons '%load-path path)))

  (defun pvm-start (who module function args)
    (pvm-send who *pvm-msg-type* (list '%start module function args)))
  
  (defun pvm-exit (who)
    (pvm-send who *pvm-msg-type* (list '%leave)))

  (export pvm-exit pvm-start pvm-set-load-path start-local-pvm
	  std-pvm-waiter default-pvm-name)
  ;; end module
  )
