;; Eulisp Module
;; Author: pete broadbery
;; File: pvm-req.em
;; Date: 9/jun/1991
;;
;; Project:
;; Description: 
;; allows non-busy wait on pvm channels
;;

(defmodule pvm-req 
  (standard0
   list-fns
   pvm
   )
  ()
  
  (defstruct pvm-waiter ()
    ((chans initform () 
	    accessor pvm-wait-chans)
     (lock initform (make-semaphore)
	   reader pvm-wait-lock))
    constructor make-pvm-waiter)

  (defun pvm-wait-loop (waiter)
    (let ((x (pvm-probe -1)))
      (cond ((null x)
	     (thread-reschedule)
	     (pvm-wait-loop waiter))
	    (t
	     (activate-pvm-waiter waiter x)
	     (thread-reschedule)
	     (pvm-wait-loop waiter)))))

  (defun activate-pvm-waiter (waiter n)
    (open-semaphore (pvm-wait-lock waiter))
    (let ((next-obj (find-match waiter n)))
      (if next-obj 
	  (thread-start next-obj)
	()))
    (close-semaphore (pvm-wait-lock waiter)))

  (defun find-match (waiter n)
    (let ((pair (check-match (pvm-wait-chans waiter) n ())))
      ((setter pvm-wait-chans) waiter (cdr pair))
      (car pair)))

  ;; returns (thread . lst)
  (defun check-match (l n a-lst)
    (cond ((null l) 
	   (cons () (nreverse a-lst)))
	  ((= (caar l) n)
	   (format t "match: got: ~a~%" (car l))
	   (cons (cadar l)
		 (nconc (reverse a-lst) (cdr l))))
	  (t (check-match (cdr l) n (cons (car l) a-lst)))))

  (defun add-pvm-waiter (waiter thread n)
    (open-semaphore (pvm-wait-lock waiter))
    ((setter pvm-wait-chans) waiter 
     (cons (list n thread)
	   (pvm-wait-chans waiter)))
    (format t "Add: lst now: ~a~%" (pvm-wait-chans waiter))
    (close-semaphore (pvm-wait-lock waiter)))

  (defun start-pvm-waiter (waiter)
    (thread-start (make-thread pvm-wait-loop)
		  waiter))

  (export make-pvm-waiter add-pvm-waiter start-pvm-waiter)
  
  ;; end module
  )


