;; Eulisp Module
;; Author: pete broadbery
;; File: client.em
;; Date: 2/jun/1991
;;
;; Project:
;; Description: 
;; provides basic fn.alily for clients
;;

(defmodule client 
  (standard0
   list-fns
   comm-low
   )
  ()

  ;; structures 

  (defstruct abs-client ()
    ()
    prediacate clientp)

  (defstruct client ()
    ((aq-list initform (mk-finder)
	      reader client-aqs))
    )

  (defstruct remote-client abs-client
    ())

  (export abs-client client remote-client)
  ;; initialisation

  ;; aquaintances

  (defgeneric client-aq-ref (client name))
  (defgeneric client-aq-ref-setter (client name value))

  ((setter setter) client-aq-ref client-aq-ref-setter)

  (defmethod client-aq-ref ((cl client) name)
    ((client-aqs cl) name))

  (defmethod (setter client-aq-ref) ((cl client) name value)
    ((setter (client-aqs cl)) name value))

  (export client-aq-ref)
  ;;
  ;;; dispatch loop
  ;;


  (defgeneric dispatch-message (client msg))
  (defgeneric find-msg-handler (ob msg))
  (defgeneric setter-find-msg-handler (ob msg fn))
  (defgeneric read-messages (ob))
  (defgeneric dispatch (ob))

  ((setter setter) find-msg-handler setter-find-msg-handler)

  (defmethod dispatch (client)
    (mapc (lambda (msg)
	    (dispatch-message client msg))
	  (read-messages client)))

  (defun dispatch-loop (ob)
       (cond ((not (killed-p ob))
	      (let/cc retry
		(with-handler 
		 (lambda (cond cont)
		   (backtrace)
		   (format t "name:~a~%message:~a~%value:~a~%"
			   (condition-name cond)
			   (condition-message cond)
			   (condition-error-value cond))
		   (retry))
		 (dispatch ob)))
	      (thread-reschedule)
	      (dispatch-loop ob))
	     (t (format t "Killed~%")
		nil)))

  (defmethod dispatch-message ((client client) msg)
    ((find-msg-handler client msg) client  msg))

  (defun start-dispatch-loop (ob)
    (thread-start (make-thread dispatch-loop) ob)
    (thread-reschedule))
  
  (export find-msg-handler dispatch-message read-messages
	  start-dispatch-loop dispatch)


  ;; end module
  )
