(defmodule utils (standard0) () (defun await-function (fn) ((lambda (result) (if (null result) (progn (thread-reschedule) (await-function fn)) result)) (fn))) (defmacro await exp (cons (quote await-function) (cons (cons (quote lambda) (cons () (append exp ()))) ()))) (export await await-function) (defmacro critical-progn (sem . body) ((lambda (semvar resvar) (cons (quote let/cc) (cons (quote critical-return) (cons (cons (quote let) (cons (cons (cons semvar (cons sem ())) (cons (cons resvar (cons () ())) ())) (cons (cons (quote open-semaphore) (cons semvar ())) (cons (cons (quote unwind-protect) (cons (cons (quote setq) (cons resvar (cons (cons (quote progn) (append body ())) ()))) (cons (cons (quote close-semaphore) (cons semvar ())) ()))) (cons resvar ()))))) ())))) (gensym) (gensym))) (defun exclusive (fn) ((lambda (sem) (lambda a (open-semaphore sem) ((lambda (res) (close-semaphore sem) res) (apply fn a)))) (make-semaphore))) (defmacro defexfun (name args . rest) (cons (quote defconstant) (cons name (cons (cons (quote exclusive) (cons (cons (quote lambda) (cons args (append rest ()))) ())) ())))) (export critical-progn exclusive defexfun) (defconstant key-list-error (make-instance condition-class (quote name) (quote key-list-error) (quote direct-superclasses) (list condition) (quote direct-slot-descriptions) (list (list (quote name) (quote key-list) (quote slot-class) local-slot-description (quote initargs) (quote (key-list)) (quote initform) (lambda () ())) (list (quote name) (quote key) (quote slot-class) local-slot-description (quote initargs) (quote (key)) (quote initform) (lambda () ()))))) (defconstant *key-list-ref-failed* (gensym)) (defun key-list-ref (l key) (if (null l) (progn *key-list-ref-failed*) (if (null (cdr l)) (progn (error "key-list-ref: unbalanced key list" key-list-error (quote key-list) l (quote key) key)) (if (eq (car l) key) (progn (car (cdr l))) (if t (progn (key-list-ref (cdr (cdr l)) key)) ()))))) (export key-list-error *key-list-ref-failed* key-list-ref) (defun mapv (fn . vecs) ((lambda (len) ((lambda (iterate) (setq iterate (lambda (i) (if (= i len) () (progn (apply fn (mapcar (lambda (v) (vector-ref v i)) vecs)) (iterate (+ i 1)))))) (iterate 0)) ())) (apply min (mapcar vector-length vecs)))) (export mapv) (defun mapcan (*fn* . x) ((lambda (len) (if (= len 1) (progn (mapcan1 *fn* (car x))) (if (= len 2) (progn (mapcan2 *fn* (car x) (cadr x))) (if (= len 3) (progn (mapcan3 *fn* (car x) (cadr x) (caddr x))) (if t (progn (error 0 "mapcan unfinished")) ()))))) (list-length x))) (defun mapcan1 (*fn* x) (if (not (consp x)) nil (nconc (*fn* (car x)) (mapcan1 *fn* (cdr x))))) (defun mapcan2 (*fn* x y) (if ((lambda (@) (if @ @ (not (consp y)))) (not (consp x))) nil (nconc (*fn* (car x) (car y)) (mapcan2 *fn* (cdr x) (cdr y))))) (defun mapcan3 (*fn* x y z) (if ((lambda (@) (if @ @ ((lambda (@) (if @ @ (not (consp z)))) (not (consp y))))) (not (consp x))) nil (nconc (*fn* (car x) (car y) (car z)) (mapcan3 *fn* (cdr x) (cdr y) (cdr z))))) (export mapcan) (defun map-indices (fn n last inc) (if (= n last) (progn (fn n) ()) (progn (fn n) (map-indices fn (+ n inc) last inc)))) (defun map-indices-collecting (fn n last inc) (if (= n last) (cons (fn n) ()) (cons (fn n) (map-indices-collecting fn (+ n inc) last inc)))) (defmacro for-index (var start end inc . body) (cons (quote map-indices) (cons (cons (quote lambda) (cons (cons var ()) (append body ()))) (cons start (cons end (cons inc ())))))) (defmacro collect-index (var start end inc . body) (cons (quote map-indices-collecting) (cons (cons (quote lambda) (cons (cons var ()) (append body ()))) (cons start (cons end (cons inc ())))))) (export map-indices map-indices-collecting for-index collect-index) (defun map-stream (code endp inc) (if (endp) nil (progn (code) (inc) (map-stream code endp inc)))) (defmacro for-stream (var start endp inc tidy . body) (cons (quote let/cc) (cons (quote return) (cons (cons (quote let) (cons (cons (cons var (cons start ())) ()) (cons (cons (quote map-stream) (cons (cons (quote lambda) (cons (cons var ()) (append body ()))) (cons (cons (quote lambda) (cons () (cons endp ()))) (cons (cons (quote lambda) (cons () (cons (cons (quote setq) (cons var (cons inc ()))) ()))) ())))) (cons tidy ())))) ())))) (export map-stream for-stream) (defmacro for-list (var list . body) (cons (quote mapc) (cons (cons (quote lambda) (cons (cons var ()) (append body ()))) (cons list ())))) (defmacro collect-list (var list . body) (cons (quote mapc) (cons (cons (quote lambda) (cons (cons var ()) (append body ()))) (cons list ())))) (export for-list collect-list) (defmacro for-table (keyvar valvar tab . body) (cons (quote map-table) (cons (cons (quote lambda) (cons (cons keyvar (cons valvar ())) (append body ()))) (cons tab ())))) (export for-table) (defun assq-list-ref (l k) (if (null l) (progn ()) (if (eq (car (car l)) k) (progn (cdr (car l))) (if t (progn (assq-list-ref (cdr l) k)) ())))) (defun map-psl-for (code endp inc) (if (endp) nil (progn (code) (inc) (map-psl-for code endp inc)))) (defmacro psl-for forms ((lambda (forexp untilexp finallyexp doexp) (cons (quote let/cc) (cons (quote return) (cons (cons (quote let) (cons (cons (cons (car forexp) (cons (cons (quote car) (cons (cons (quote cdr) (cons (quote forexp) ())) ())) ())) ()) (cons (cons (quote map-psl-for) (cons (cons (quote lambda) (cons () (append doexp ()))) (cons (cons (quote lambda) (cons () (append untilexp ()))) (cons (cons (quote lambda) (cons () (cons (cons (quote progn) (append (car (cdr (cdr forexp))) ())) ()))) ())))) (append finallyexp ())))) ())))) (assq-list-ref forms (quote for)) (assq-list-ref forms (quote until)) (assq-list-ref forms (quote finally)) (assq-list-ref forms (quote do)))) (export assq-list-ref map-psl-for psl-for))