;; generic handler for all message types
;; Any logical thread should regularly call these fuctions
;; assumption: if control is given to this function, 
;;             then no thread can advance
;; interface:
;;   register-handler (msg-id closure)
;;   handle-msgs

(defmodule handler 
    (standard0
     list-fns
     
     reader
     pvm-support
     
     )
  ()

  ;; tacky-hack time: handler is a lexical structure
  
  ;; and std-reader is not
  
  (defstruct handler-object ()
     ((idents initform ()
	      initarg idents
	      accessor handler-idents)
      ;; sparse representation
      (callbacks initform ()
		 initarg callbacks
		 accessor handler-callbacks))
     constructor make-handler)

  (defun the-handler () (dynamic *the-handler*))
  
  (defvar *the-handler* (make-handler))

  (export the-handler)

  (deflocal *reader* (make-obj-reader))

  (defun default-reader ()
    *reader*)

  ((setter setter) default-reader
   (lambda (reader)
     (setq *reader* reader)))
  
  (export default-reader)

  (defun register-handler (n fn)
    (if (assoc n (handler-callbacks (the-handler)) =)
	((setter handler-callbacks) (the-handler)
	 (exchange (handler-callbacks (the-handler)) n fn))
	(progn ((setter handler-idents) (the-handler) 
		(cons n (handler-idents (the-handler))))
	       ((setter handler-callbacks) (the-handler)
		(cons (cons n fn)
		      (handler-callbacks (the-handler))))))
    (the-handler))
  
  (defun exchange (lst n fn)
    (if (= n (caar lst)) 
	(cons (cons n fn)
	      (cdr lst))
	(cons (car lst) (exchange (cdr lst) n fn))))

  (defun handle-msgs (new-handlers remove)
    (with-new-handler new-handlers remove
      (lambda ()
	(flush (standard-output-stream))
	(if (null (handler-idents (the-handler))) 
	    (error "oh rats" clock-tick)
	    ())
	(let ((msg (pvm-recv-multi (handler-idents (the-handler))
				   t (default-reader))))
	  ((cdr (assoc (caddr msg)
		       (handler-callbacks (the-handler))
		       =))
	   msg)))))

  (defun probe-handle-msgs (new-handlers remove-handlers)
    (with-new-handler 
	new-handlers remove-handlers
	(lambda ()
	  (let ((x (pvm-probe-multi (handler-idents (the-handler)))))
	    (if (null x) nil
		(let ((msg (pvm-recv x t (default-reader))))
		  ((cdr (assoc (caddr msg)
			       (handler-callbacks (the-handler))
			       =))
		   msg)
		  t))))))
  
  (defun with-new-handler (new del fn)
    (let ((ids (handler-idents (the-handler)))
	  (callbacks (handler-callbacks (the-handler))))
      (mapc (lambda (x) 
	      ((setter handler-idents) (the-handler)
	       (delete x (handler-idents (the-handler)) =)))
	    del)
      (mapc (lambda (x) (register-handler (car x) (cdr x)))
	    new)
      (let ((res (fn)))
	((setter handler-idents) (the-handler) ids)
	((setter handler-callbacks) (the-handler) callbacks)
	res)))

  (export register-handler handle-msgs probe-handle-msgs)

)




