;; Eulisp Module
;; Author: ~un
;; File: ~fn
;; Date: ~dd/~dm/~dY
;;
;; Project:
;; Description: allocation junk
;;

(defmodule allocator
  (standard0
   list-fns
   
   low-dvsm
   page-mapper
   page
   )
  ()
       
  
  ;; Allocation
  ;; and deallocation.
  ;; This is the point where we reserve space for 
  ;; doing wonderous things... like GC

  (defcondition allocate-error ())

  (defstruct allocator ()
	     ()
	     predicate allocator-p)
  
  ;; fake for initialisation
  (defstruct null-allocator allocator
     ()
     constructor (make-null-allocator)
     predicate null-allocator-p)

  (export make-null-allocator null-allocator-p)

  (defmethod allocate-space ((x null-allocator) n class)
    (error "can not allocate on this object" allocate-error ))

  ;; bit too simple --- needs free list, etc.
  (defstruct simple-allocator allocator 
    ((mapper initarg mapper
	     reader allocator-mapper)
     (alloc-page initarg alloc-page
		 initform (make-alloc-page 400)
		 accessor allocator-page)
     (alloc-loc initform 0
		accessor allocator-loc))
    constructor make-simple-allocator)

  (export make-simple-allocator)

  ;; allocation-pages... make life a bit easier
  (defstruct alloc-page page
    ()
    constructor (make-alloc-page size))

  (defmethod initialize-instance ((x alloc-page) lst)
    (let ((new (call-next-method)))
      ;;((setter page-id) x 'alloc)
      new))

  (defmethod allocate-space ((sa simple-allocator) size class)
    (let ((loc (allocator-loc sa)))
      (cond ((< (+ loc size) 
		(page-size (allocator-page sa)))
	     ((setter allocator-loc) sa
	      (+ loc size))
	     (make-address loc (allocator-page sa) class))
	    (t  ;; hack
	     (error "Ran out of space...." allocate-error)))))

  ;; making pages

  (defun map-new-page (mapper)
    (if (< (page-mapper-pcount mapper)
	   (max-pages-in-map mapper))
	(let* ((id (make-page-id mapper (page-mapper-pcount mapper)))
	       (new-page (make-instance (page-class mapper) 'id id)))
	  (map-real-page mapper id new-page 'new)
	  id)
	(error "No more pages --- sorry" allocate-error)))
  
  ;; mapping a simple-page
  (defgeneric map-real-page (mapper id page status)
    methods ((((x page-mapper) id page status)
	      ((setter vector-ref) (page-mapper-map mapper) id page))
	     ))

  (export map-real-page)
  
			  

  )
  

