(defmodule list-fns
  (standard0)
  ()
  ;;
  ;;  (union (expose  arith others ccc vectors defs extras0 macros0  lists list-operators)	
  ;;(except (null vector) (expose class-names)))

  ;; Useful function not defined EulispLISP
  (defun deleq (a b)
    (cond
     ((null b) nil)
     ((eq a (car b))
      (cdr b))
     (t (cons (car b) (deleq a (cdr b)))) ))

  (defun mapcdr (fn lst)
    (cond ((null lst) (fn nil))
	  (t (cons (fn lst)
		   (mapcdr fn (cdr lst))))))
  (export mapcdr)
    
  
  (defun map-all (fn lst)
    (cond ((null lst) nil)
	  ((atom lst) lst)
	  ((consp (car lst))
	   (cons (map-all fn (car lst))
		 (map-all fn (cdr lst))))
	  (t (cons (fn (car lst))
		   (map-all fn (cdr lst))))))


  (defun fold (fn lst init)
    (cond ((null lst) init)
	  (t (fold fn (cdr lst) 
		   (fn (car lst) init)))))

  (defun mapvect (fn vect)
    (mapvect-aux fn (vector-length vect) (make-vector (vector-length vect) nil) vect))

  ;; work in RL direction (for peversity)
  (defun mapvect-aux (fn i new-v old-v)
    (cond ((zerop i) new-v)
	  (t ((setter vector-ref) new-v (- i 1) (fn (vector-ref old-v (- i 1))))
	     (mapvect-aux fn (- i 1) new-v old-v))))
 (defun collect (p l)
    (cond ((null l) nil)
	  ((p (car l)) (cons (car l)
			     (collect p (cdr l))))
	  (t (collect p (cdr l)))))

   (defun nth (n list)
    (cond ((= n 0) (car list))
	  (t (nth (- n 1) (cdr list)))))

  (export mapvect fold  map-all deleq collect nth)
) 

