
/* Copyright Massachusetts Institute of Technology 1990,1991 */

#ifndef lint
static char rcsid[] = "$Header: _set_alarm.c,v 1.2 91/06/06 13:50:33 dcurtis Exp $";
#endif lint
/* $Log:	_set_alarm.c,v $
 * Revision 1.2  91/06/06  13:50:33  dcurtis
 * added copyright notice
 * 
 * Revision 1.1  91/02/04  23:20:57  mtv
 * Initial revision
 * 
 */

/*						*/
/*		IMPLEMENTATION OF		*/
/*			_set_alarm		*/
/*						*/

#include <signal.h>
#undef signal
#include "pclu_err.h"
#include "pclu_sys.h"
#include <sys/time.h>
#include <errno.h>

extern char **environ;
extern int errno;

static bool itimer_flag = false;
extern void alarm();

errcode _set_alarm(secs, ans, elist)
CLUREF secs, *ans;
errlist elist;
{
int uerr;
char *addr;
errcode err;
CLUREF temp;
struct sigvec vec, ovec;
struct itimerval value;
int which;

	if (secs.num > 0) {
		vec.sv_handler = alarm;
		vec.sv_mask = -1;
		vec.sv_flags = 1;
		uerr = sigvec(SIGALRM, vec, ovec);
		}
	which = ITIMER_REAL;
	value.it_interval.tv_sec = 0;
	value.it_interval.tv_usec = 0;
	value.it_value.tv_sec = secs.num;
	value.it_value.tv_usec = 0;
	ans->tf = itimer_flag;
	itimer_flag = false;
	uerr = setitimer(which, &value, 0);
	signal(ERR_ok);
	}

void alarm(sig, code, scp)
int sig, code;
struct sigcontext *scp;
{
	itimer_flag = true;
	return;
	}
