
/* Copyright Massachusetts Institute of Technology 1990,1991 */

#ifndef lint
static char rcsid[] = "$Header: _select.c,v 1.2 91/06/06 13:50:24 dcurtis Exp $";
#endif lint
/* $Log:	_select.c,v $
 * Revision 1.2  91/06/06  13:50:24  dcurtis
 * added copyright notice
 * 
 * Revision 1.1  91/02/04  23:20:56  mtv
 * Initial revision
 * 
 */

/*						*/
/*		IMPLEMENTATION OF		*/
/*			_select			*/
/*						*/

#include "pclu_err.h"
#include "pclu_sys.h"
#include <sys/time.h>
#include <errno.h>

extern char **environ;
extern int errno;

errcode _select(cnt, reads, writes, excepts, millis, 
			ans1, ans2, ans3, ans4, elist)
CLUREF cnt, reads, writes, excepts, millis;
CLUREF *ans1, *ans2, *ans3, *ans4;
errlist elist;
{
int uerr;
char *addr;
errcode err;
CLUREF temp;
int nfound;
struct timeval timeout;
int rwreads = reads.num;
int rwwrites = writes.num;
int rwexcepts = excepts.num;

	timeout.tv_sec = millis.num / 1000;
	timeout.tv_usec = millis.num % 1000;
	nfound = select(cnt, &rwreads, &rwwrites, &rwexcepts, &timeout);
	if (nfound >= 0) {
		ans1->num = nfound;
		ans2->num = rwreads;
		ans3->num = rwwrites;
		ans4->num = rwexcepts;
		signal(ERR_ok);	
		}
	if (nfound == -1 && errno == EINTR) {
		ans1->num = 0;
		ans2->num = 0;
		ans3->num = 0;
		ans4->num = 0;
		signal(ERR_ok);	
		}
	elist[0] = _unix_erstr(errno);
	signal(ERR_not_possible);
	}

