
/* Copyright Massachusetts Institute of Technology 1990,1991 */

#ifndef lint
static char rcsid[] = "$Header: _tagcell.c,v 1.4 91/06/06 13:26:02 root Exp $";
#endif lint
/* $Log:	_tagcell.c,v $
 * Revision 1.4  91/06/06  13:26:02  root
 * added copyright notice
 * 
 * Revision 1.3  91/06/03  12:09:43  root
 * sparcstation compatibility: int->CLUREF
 * 
 * Revision 1.2  91/05/31  11:54:21  root
 * fixed aggregate initialization in ops_actual
 * changed int arguement to CLUREF in copy operation
 * 
 * Revision 1.1  91/02/04  15:49:37  mtv
 * Initial revision
 * 
 */

 /*						*/
/*						*/
/*		IMPLEMENTATION OF		*/
/*			_tagcell		*/
/*						*/

#include "pclu_err.h"
#include "pclu_sys.h"

extern errcode clu_alloc();

typedef struct {
int count;
struct REQ_ENTRY entry[1];
} _tagcell_of_t_REQS;

typedef struct {
int count;
OWNPTR type_owns;
OWNPTR op_owns;
struct OP_ENTRY _gcd;
} _tagcell_of_t_TABLE;

_tagcell_of_t_REQS _tagcell_of_t_reqs_actual = {1, "_gcd"};
_tagcell_of_t_REQS *_tagcell_of_t_reqs = &_tagcell_of_t_reqs_actual;



errcode _tagcellOPcreate(tg, val, ans, elist)
CLUREF tg, val, *ans;
errlist elist;
{
errcode err;
CLUREF temp;

	if (tg.num >= cellOPmaxtag) signal(ERR_toobig);
	err = clu_alloc(sizeof(CLU_cell), &temp);
	if (err != ERR_ok) resignal(err);
	temp.cell->typ.mark = 0;
	temp.cell->typ.val = CT_TAG;
	temp.cell->typ.refp = 0;
	temp.cell->typ.spare = 0;
	temp.cell->tag = tg.num;
	temp.cell->value = val.num;
	ans->cell = temp.cell;
	signal(ERR_ok);
	}


errcode _tagcellOPcopy(tt, ans, elist)
CLUREF tt, *ans;
errlist elist;
{
errcode err;
CLUREF tg, val, temp;

	tg.num = tt.cell->tag;
	val.num = tt.cell->value;
	err = _tagcellOPcreate(tg, val, &temp, elist);
	if (err != ERR_ok) resignal(err);
	ans->cell = temp.cell;
	signal(ERR_ok);	
	}

errcode _tagcellOPget(tt, ans1, ans2, elist)
CLUREF tt, *ans1, *ans2;
errlist elist;
{
	ans1->num = tt.cell->tag;
	ans2->num = tt.cell->value;
	signal(ERR_ok);
	}

errcode _tagcellOPset(tt, tg, val, elist)
CLUREF tt, tg, val;
errlist elist;
{
	if (tg.num > cellOPmaxtag) signal(ERR_toobig);
	tt.cell->tag = tg.num;
	tt.cell->value = val.num;
	signal(ERR_ok);
	}

errcode _tagcellOPset_value(tt, val, elist)
CLUREF tt, val;
errlist elist;
{
	tt.cell->value = val.num;
	signal(ERR_ok);
	}

errcode _tagcellOPequal(t1, t2, ans, elist)
CLUREF t1, t2, *ans;
errlist elist;
{
	if (t1.ref == t2.ref) ans->tf = true;
	else ans->tf = false;
	signal(ERR_ok);
	}

errcode _tagcellOP_gcd(tt, tab, ans, elist)
CLUREF tt, tab, *ans;
errlist elist;
{
_tagcell_of_t_TABLE *table = (_tagcell_of_t_TABLE*)CUR_PROC_VAR.proc->type_owns->info[0]; /* ptr to _gcd fcns */
errcode err;
CLUREF temp_oneof, sz, fcn;

	fcn.proc = table->_gcd.fcn;
	err = oneofOPnew(CLU_5, fcn, &temp_oneof, elist);
	if (err != ERR_ok) resignal(err);
	sz.num = 8 + GCD_REF_SIZE;
	err = gcd_tabOPinsert(tab,  sz, temp_oneof, tt, ans, elist);
	if (err != ERR_ok) resignal(err);
	signal(ERR_ok);
	}

typedef struct{
    int count;
    OWNPTR type_owns;
    OWNPTR op_owns;
    struct OP_ENTRY entry[7];
} _tagcell_OPS;


OWN_req _tagcell_ownreqs = {8,1};

OWN_ptr _tagcell_own_init = {0, 0};

CLU_proc _tagcell_oe_create = {{0,0,0,0}, _tagcellOPcreate, &_tagcell_own_init, &_tagcell_own_init};
CLU_proc _tagcell_oe_equal = {{0,0,0,0}, _tagcellOPequal, &_tagcell_own_init, &_tagcell_own_init};
CLU_proc _tagcell_oe_copy = {{0,0,0,0}, _tagcellOPcopy, &_tagcell_own_init, &_tagcell_own_init};
CLU_proc _tagcell_oe_get = {{0,0,0,0}, _tagcellOPget, &_tagcell_own_init, &_tagcell_own_init};
CLU_proc _tagcell_oe_set = {{0,0,0,0}, _tagcellOPset, &_tagcell_own_init, &_tagcell_own_init};
CLU_proc _tagcell_oe_set_value = {{0,0,0,0}, _tagcellOPset_value, &_tagcell_own_init, &_tagcell_own_init};
CLU_proc _tagcell_oe__gcd = {{0,0,0,0}, _tagcellOP_gcd, &_tagcell_own_init, &_tagcell_own_init};

_tagcell_OPS _tagcell_ops_actual = {7,
    &_tagcell_own_init,
    &_tagcell_own_init, {
    {&_tagcell_oe_create, "create"},
    {&_tagcell_oe_equal, "equal"},
    {&_tagcell_oe_copy, "copy"},
    {&_tagcell_oe_get, "get"},
    {&_tagcell_oe_set, "set"},
    {&_tagcell_oe_set_value, "set_value"},
    {&_tagcell_oe__gcd, "_gcd"}}
};

struct OPS *_tagcell_ops = (struct OPS *)&_tagcell_ops_actual;
