/* Test class OrderedCltn

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	orderedcltn.c,v $
 * Revision 2.204  89/10/07  23:51:05  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:51:27  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:23:08  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/05/11  22:25:05  keith
 * Update for R2.0.
 * 
 * Revision 2.200  89/04/24  17:34:47  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:21:30  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.2  89/02/14  23:16:55  keith
 * Add test of compare().
 * 
 * Revision 2.1  89/02/08  14:04:46  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.0  88/03/29  13:27:32  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:54  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: orderedcltn.c,v 2.204 89/10/07 23:51:05 keith Stab $";

#include "Point.h"
#include "OrderedCltn.h"
#include "Set.h"

main()
{
	cout << "\nTest class OrderedCltn\n";
	Point A(1,1);
	Point B(1,2);
	Point C(1,3);
	Point D(1,3);
	OrderedCltn b(16);
	OrderedCltn c;
	b.add(A);
	b.add(B);
	b.add(C);
	b.add(D);
	cout << "b = " << b << endl;
	cout << "b.first(): " << *(b.first()) << endl;
	cout << "b.last(): " << *(b.last()) << endl;
	b.addAfter(Point(1,2),Point(1,21));
	b.addBefore(Point(1,2),Point(1,19));
	cout << "b = " << b << endl;
	cout << "b.after(Point(1,2)): " << *(b.after(Point(1,2))) << endl;
	cout << "b.before(Point(1,2)): " << *(b.before(Point(1,2))) << endl;
	c = b;
	b.reSize(30);
	cout << "b.includes(C): " << b.includes(C) << endl;
	cout << "c == b: " << (c==b) << endl;
	cout << "b.compare(c): " << b.compare(c) << endl;
	b.addAllLast(c);
	cout << "b = " << b << endl;
	cout << "b.compare(c): " << b.compare(c) << endl;
	cout << "c.compare(b): " << c.compare(b) << endl;
	b.remove(C);
	cout << "b.includes(C): " << b.includes(C) << endl;
	cout << "b = " << b << endl;
	cout << "c == b: " << (c==b) << endl;
	cout << "b.compare(c): " << b.compare(c) << endl;
	cout << "c&b:" << (c&b) << endl;
	cout << "b.indexOfSubCollection(c): " << b.indexOfSubCollection(c,1) << endl;
	cout << "c = " << c << endl;
	b.replaceFrom(1,3,c);
	cout << "b.replaceFrom(1,3,c): " << b << endl;
	b.sort();
	cout << "b.sort(): " << b << endl;
	cout << "b.asSet(): " << (b.asSet()) << endl;
}
