#ifndef	TIME_H
#define	TIME_H

/*$Header: Time.h,v 2.204 89/10/07 23:22:09 keith Stab $*/

/* Time.h -- declarations for class Time

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Time.h,v $
 * Revision 2.204  89/10/07  23:22:09  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:24:56  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:56:36  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:56:37  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:18:14  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/21  13:06:02  keith
 * Add VIRTUAL to base class specification.
 * Make typedefs local to class.
 * Change value Time args to const Time& args.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:47  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:48:38  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:21:00  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  11:02:50  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:19:39  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:32:02  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:10:24  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class Date;

class Time: public VIRTUAL Object {
	DECLARE_MEMBERS(Time);
public:			// type definitions
	typedef unsigned short hourTy;
	typedef unsigned short minuteTy;
	typedef unsigned short secondTy;
	typedef unsigned long clockTy;
private:
	clockTy sec;			/* seconds since 1/1/1901 */
	bool isDST() const;
	Time localTime() const;
private:		// static member functions
	static Time localTime(const Date& date, hourTy h=0, minuteTy m=0, secondTy s=0);
	static Time beginDST(unsigned year);
	static Time endDST(unsigned year);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Time();				// current time 
	Time(clockTy s)			{ sec = s; }
	Time(hourTy h, minuteTy m, secondTy s =0, bool dst =NO);
	Time(const Date&, hourTy h =0, minuteTy m =0, secondTy s=0, bool dst =NO);
	operator Date() const;
	bool operator<(const Time& t) const	{ return sec < t.sec; }
	bool operator<=(const Time& t) const	{ return sec <= t.sec; }
	bool operator>(const Time& t) const	{ return sec > t.sec; }
	bool operator>=(const Time& t) const	{ return sec >= t.sec; }
	bool operator==(const Time& t) const	{ return sec == t.sec; }
	bool operator!=(const Time& t) const	{ return sec != t.sec; }
	friend Time operator+(const Time& t, long s) const { return Time(t.sec+s); }
	friend Time operator+(long s, const Time& t) const { return Time(t.sec+s); }
	long operator-(const Time& t) const	{ return sec - t.sec; }
	Time operator-(long s) const	{ return Time(sec-s); }
	void operator+=(long s)		{ sec += s; }
	void operator-=(long s)		{ sec -= s; }
	bool between(const Time& a, const Time& b) const;
	hourTy hour() const;		// hour in local time 
	hourTy hourGMT() const;		// hour in GMT 
	minuteTy minute() const;	// minute in local time 
	minuteTy minuteGMT() const;	// minute in GMT 
	secondTy second() const;	// second in local time or GMT 
	clockTy	seconds() const		{ return sec; }
	Time max(const Time&) const;
	Time min(const Time&) const;
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
};

#endif /* TIMEH */
