#ifndef	STACK_H
#define	STACK_H

/*$Header: Stack.h,v 2.204 89/10/07 23:21:50 keith Stab $*/

/* Stack.h -- declarations for class Stack

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Stack.h,v $
 * Revision 2.204  89/10/07  23:21:50  keith
 * Pre-release
 * 
 * Revision 2.203.1.1  89/09/09  20:09:55  keith
 * Eliminate isEqual() and species().
 * 
 * Revision 2.203  89/08/08  15:24:35  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/07  14:04:01  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:56:17  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:56:17  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:17:51  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:36  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:48:21  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:20:40  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  11:02:06  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  10:00:07  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:10:40  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:19:00  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:39  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:09:47  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "OrderedCltn.h"

class Stack: public SeqCltn {
	DECLARE_MEMBERS(Stack);
	OrderedCltn contents;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Stack(unsigned size =DEFAULT_CAPACITY);
	bool operator==(const Stack& s) const
		{ return contents == s.contents; }
	bool operator!=(const Stack& s)	const { return !(*this==s); }
	void operator=(const Stack& s)	{ contents = s.contents; }
	Object*& operator[](int i)	{ return contents.at(size()-i-1); }
	const Object *const& operator[](int i) const	{ return contents.at(size()-i-1); }
	void push(Object& ob)		{ contents.addLast(ob); }
	Object* pop()			{ return contents.removeLast(); }
	Object* top() const		{ return contents.last(); }
	virtual Object* add(Object& ob);
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual unsigned hash() const;
	virtual bool isEmpty() const;
	virtual Object* last() const;
	virtual void reSize(unsigned newSize);
	virtual void removeAll();
	virtual Object* removeLast();
	virtual unsigned size() const;
private:			    // shouldNotImplement();
	virtual void atAllPut(Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual Object* remove(const Object&);
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
};

#endif
