#ifndef	OIONIH_H
#define	OIONIH_H

/*$Header: OIOnih.h,v 2.204 89/10/07 23:20:35 keith Stab $*/

/* OIOnih.h -- declarations for "NIH-format" stream Object I/O classes

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892
	May, 1989

Modification History:

$Log:	OIOnih.h,v $
 * Revision 2.204  89/10/07  23:20:35  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:15  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:08  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:05  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/21  10:56:35  keith
 * Add explicit base class names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/01  23:16:39  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201  89/05/12  11:19:08  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200  89/05/12  10:50:13  keith
 * Initial revision for R2.0.
 * 
*/
#include "OIOstream.h"

class OIOnihin : public OIOistream {
protected:
	virtual Object* readObject(const Class&);
public:
	OIOnihin(istream& s) : OIOistream(s) {}
};

class OIOnihout : public OIOostream {
protected:
	virtual void storeObject(const Object&);
public:
	OIOnihout(ostream& s) : OIOostream(s) {}
};

#endif
