#ifndef	IDENTDICT_H
#define	IDENTDICT_H

/*$Header: IdentDict.h,v 2.204 89/10/07 23:19:45 keith Stab $*/

/* IdentDict.h -- declarations for Identity Dictionary

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	IdentDict.h,v $
 * Revision 2.204  89/10/07  23:19:45  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:14  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/03  16:23:08  keith
 * Define storer() functions as workaround for BUG_38
 * in AT&T C++ Translator 2.00.
 * 
 * Revision 2.202.1.1  89/07/01  21:54:17  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:15  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:14:02  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:15:57  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:59  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:15  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:58:47  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/04/25  10:08:32  keith
 * Remove unused reference to class OrderedCltn.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:09  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:49  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:05  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Dictionary.h"

class LookupKey;

class IdentDict: public Dictionary {
	DECLARE_MEMBERS(IdentDict);
	virtual int findIndexOf(const Object&) const;
#ifndef BUG_38
// internal <<AT&T C++ Translator 2.00 06/30/89>> error: bus error (or something nasty like that)
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ Dictionary::storer(fd); };
	virtual	void storer(OIOout& strm) const	{ Dictionary::storer(strm); };
#endif
public:
	IdentDict(unsigned size =DEFAULT_CAPACITY);
	void operator=(const IdentDict&);
	virtual LookupKey* assocAt(const Object& key) const;
	virtual Object* atKey(const Object& key) const;
	virtual Object* atKey(const Object& key, Object& newValue);
	virtual bool includesKey(const Object& key) const;
};

#endif
