/* Dictionary.c -- implementation of Set of Associations

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:
	
A Dictionary is a Set of Associations.  A Dictionary returns the value
of an association given its key.

$Log:	Dictionary.c,v $
 * Revision 2.204  89/10/07  23:19:11  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:38  keith
 * Pre-release
 * 
 * Revision 2.202.1.4  89/07/08  19:11:16  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.3  89/07/03  23:08:52  keith
 * Change assocAt() to return 0 instead of nil when assocation
 * not found.
 * 
 * Revision 2.202.1.2  89/07/03  15:50:44  keith
 * Replace explicit use of Iterator with DO ... OD.
 * 
 * Revision 2.202.1.1  89/07/01  21:53:38  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:37  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:12:58  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  22:44:38  keith
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:57:08  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:16:40  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:57:05  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:36  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:55  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:12  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:06  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Dictionary.h"
#include "LookupKey.h"
#include "Assoc.h"

#define	THIS	Dictionary
#define	BASE	Set
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Dictionary,0,"$Header: Dictionary.c,v 2.204 89/10/07 23:19:11 keith Stab $",NULL,NULL);

extern const int NIHCL_DUPKEY,NIHCL_KEYNOTFOUND;

Dictionary::Dictionary(unsigned size) : BASE(size) {}

void Dictionary::operator=(const Dictionary& d)
{
	this->Set::operator=(d);
}

bool Dictionary::operator==(const Dictionary& d) const
{
	if (size() != d.size()) return NO;
	DO(*this,LookupKey,a) if (!d.includesAssoc(*a)) return NO; OD
	return YES;
}

Object* Dictionary::add(Object& ob)
{
	assertArgClass(ob,*LookupKey::desc(),"add");
	return Set::add(ob);
}

Assoc* Dictionary::addAssoc(Object& key, Object& value)
{
	Assoc* a = new Assoc(key,value);
	Assoc* b = Assoc::castdown(Set::add(*a));
	if (a != b) {
		delete a;
		setError(NIHCL_DUPKEY,DEFAULT,this,className(),"addAssoc",key.className(),&key);
	}
	return b;
}

Collection& Dictionary::addContentsTo(Collection& cltn) const
{
	DO(*this,LookupKey,a) cltn.add(*(a->value())); OD
	return cltn;
}

Object* Dictionary::remove(const Object& ob)
{
	assertArgClass(ob,*LookupKey::desc(),"remove");
	return Set::remove(ob);
}

Object* Dictionary::atKey(const Object& key) const
{
	register Object* p = findObjectWithKey(key);
	if (p==nil) setError(NIHCL_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key);
	else return LookupKey::castdown(p)->value();
}

Object* Dictionary::atKey(const Object& key, Object& newValue)
{
	register Object* p = findObjectWithKey(key);
	if (p==nil) setError(NIHCL_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key);
	else return LookupKey::castdown(p)->value(newValue);
}

LookupKey* Dictionary::assocAt(const Object& key) const
{
	Object* lk = findObjectWithKey(key);
	if (lk == nil) return 0;
	return LookupKey::castdown(lk);
}

Collection& Dictionary::addKeysTo(Collection& cltn) const
{
	DO(*this,LookupKey,a) cltn.add(*a->key()); OD
	return cltn;
}

Collection& Dictionary::addValuesTo(Collection& cltn) const
{
	return addContentsTo(cltn);
}

Object* Dictionary::keyAtValue(const Object& val) const
{
	DO(*this,LookupKey,a) if (val.isEqual(*a->value())) return a->key(); OD
	return nil;
}

unsigned Dictionary::occurrencesOf(const Object& val) const
{
	unsigned n =0;
	DO(*this,LookupKey,a) if (val.isEqual(*a->value())) n++; OD
	return n;
}

bool Dictionary::includesAssoc(const LookupKey& asc) const
{
	register Object* p = findObjectWithKey(asc);
	if (p==nil) return NO;
	return asc.value()->isEqual(*(LookupKey::castdown(p)->value()));
}

bool Dictionary::includesKey(const Object& key) const
{
	if (findObjectWithKey(key) == nil) return NO;
	else return YES;
}

bool Dictionary::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && *this==castdown(ob);
}

const Class* Dictionary::species() const { return &classDesc; }

LookupKey* Dictionary::removeAssoc(const LookupKey& asc)
{
	return LookupKey::castdown(remove(asc));
}

LookupKey* Dictionary::removeKey(const Object& key)
{
	LookupKey* lk = assocAt(key);
	if (lk == 0) setError(NIHCL_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key);
	return removeAssoc(*lk);
}

Dictionary::Dictionary(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
}

Dictionary::Dictionary(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
}

int Dictionary::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
