#ifndef	ASSOCINT_H
#define	ASSOCINT_H

/*$Header: AssocInt.h,v 2.204 89/10/07 23:18:44 keith Stab $*/

/* AssocInt.h -- declarations for key-Integer association

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	AssocInt.h,v $
 * Revision 2.204  89/10/07  23:18:44  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:07  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:06  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:06  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:11:55  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  21:48:06  keith
 * Remove AssocInt(const AssocInt&).
 * 
 * Revision 2.201.1.2  89/06/01  23:14:27  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:40:18  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:07  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:56:10  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:12:38  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:40  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:10  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "LookupKey.h"
#include "Integer.h"

class AssocInt: public LookupKey {
	DECLARE_MEMBERS(AssocInt);
	Integer avalue;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	AssocInt(Object& newKey =*nil, int newValue =0);
	virtual void deepenShallowCopy();
	virtual Object* value() const;
	virtual Object* value(Object& newValue);
};

#endif
