/*$Header: Array_h.m4,v 2.204 89/10/07 23:18:35 keith Stab $*/

/* Array.h.m4 -- template for declarations for generic array objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:

m4 macro template for the .h files for arrays of the specified
fundamental type: char, int, short, long, unsigned, float, and double.
For example, to generate the declarations for an array of chars:

	echo "ARRAYDECLARE(Arraychar,char,friend SubString;)" | m4 Array.h.m4 - >Arraychar.h

$Log:	Array_h.m4,v $
Revision 2.204  89/10/07  23:18:35  keith
Pre-release

Revision 2.203  89/08/08  15:20:54  keith
Pre-release

Revision 2.202.1.1  89/07/01  21:52:56  keith
Base revision for R2.00 MI version

Revision 2.202  89/06/23  07:42:37  keith
Base revision for AT&T C++ R2.0 release (Cycle 20)

Revision 2.201.1.4  89/06/23  07:40:20  keith
Change return type of oprerator[]() to value instead of
const reference.

Revision 2.201.1.3  89/06/22  10:11:28  keith
Remove unnecessary copy constructors.

Revision 2.201.1.2  89/06/01  23:59:25  keith
Add Header RCS identification string.
Remove base class arg from DECLARE_MEMBERS.

Revision 2.201.1.1  89/05/19  15:40:09  keith
Add base class arg to DECLARE_MEMBERS.
Place enums and typedefs in classes.

Revision 2.201  89/05/12  11:15:42  keith
Release for R2.0 Beta test.

Revision 2.200.1.4  89/05/12  10:55:40  keith
Revised Object I/O.

Revision 2.200.1.3  89/05/05  09:56:34  keith
Overload reference-returning member functions (e.g.
operator[](int) and at(int) for const instances.

Revision 2.200.1.2  89/05/03  23:06:42  keith
Utilize abstract classes.

Revision 2.200.1.1  89/04/24  16:51:18  keith
Working revision for R2.0 Beta 6++

Revision 2.200  89/04/17  23:27:27  keith
Base revision for R2.0 Beta 6.

Revision 2.121  89/02/16  11:02:50  keith
Base revision for C++ R1.2.1 compatible version.

*/

define(ARRAYDECLARE,
``#ifndef'' $1_H
``#define'' $1_H

``#include'' "Collection.h"
``#include'' <malloc.h>

inline $2* REALLOC($2* ptr, unsigned size)
{
	return ($2*)realloc((char*)ptr,sizeof($2)*size);
}

inline void DELETE($2* ptr) { free((char*)ptr); }

class $1: public Collection {
	DECLARE_MEMBERS($1);
	$2* v;
	unsigned sz;
	void AllocSizeErr() const;
	void IndexRangeErr() const;
// friends go here
	$3
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	$1(unsigned size =DEFAULT_CAPACITY);
	$1(const $1&);
	~$1();
	$2& elem(int i)			{ return v[i]; }
	const $2& elem(int i) const	{ return v[i]; }
	bool operator!=(const $1& a) const { return !(*this==a); }
	void operator=(const $1&);
	bool operator==(const $1&) const;
	$2& operator[](int i) {
		if ((unsigned)i >= sz) IndexRangeErr();
		return v[i];
	}
	$2 operator[](int i) const {
		if ((unsigned)i >= sz) IndexRangeErr();
		return v[i];
	}
	virtual unsigned capacity() const;
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void reSize(unsigned);
	virtual unsigned size() const;
	virtual void sort();
	virtual const Class* species() const;
private:					// shouldNotImplement()
	virtual Object* add(Object&);
	virtual Object*& at(int);
	virtual const Object *const& at(int) const;
	virtual Object* doNext(Iterator&) const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&);
	virtual void removeAll();
};

``#endif''
)
