// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef MultiCpuMuxExceptions_h
#define MultiCpuMuxExceptions_h
#pragma once

#include <ExceptionClass.h>

//
//	ExceptionRelocate -- Can also be
//	used to move to another CPU (i.e. previous to killing a cpu or
//	spawning a CPU)
//

class ExceptionRelocate : public ExceptionClass {
    int newCpu;
public:
    ExceptionRelocate();
    void cpu(int = -1);
    virtual void handleException();
};

inline
ExceptionRelocate::ExceptionRelocate()
{
}

inline void
ExceptionRelocate::cpu(int c)
{
    newCpu = c;
}

//
// ExceptionEnrollDismissCpu -- enroll or dismiss a new cpu.
//
class ExceptionEnrollDismissCpu : public ExceptionClass {
    int enrollOrDismiss;
public:
    void enroll();
    void dismiss();
    virtual void handleException();
};

inline void
ExceptionEnrollDismissCpu::enroll()
{
    enrollOrDismiss = 1;
}

inline void
ExceptionEnrollDismissCpu::dismiss()
{
    enrollOrDismiss = 0;
}

#endif /* MultiCpuMuxExceptions_h */
