#include <stream.h>
#include "SimulationMultiplexor.h"
#include "Main.h"
#include "Recv.h"
#include "assert.h"

Recv *theRecvs[MAX_RECVS];

Recv::Recv(int xpid) : ( "RECV", 10000, (ThreadPriority)-xpid, (bool)0)
{
    pid = xpid;
    sprintf(nameBuffer,"Recv-%d", pid);
    name(nameBuffer);
}

void
Recv::main()
{
    CpuCerrLock.reserve();
    cout << "Hi mom, I'm #" << pid << "\n";
    CpuCerrLock.release();

    while(1) {
	int msg = remove();

	CpuCerrLock.reserve();
	cout << "#" << pid << " got message " << msg;
	cout << " at " << simulatedClock() << "\n";
	CpuCerrLock.release();
	hold(pid);
    }
}

void
Recv::add(int message)
{
    AwesimeFifoItem foo = (AwesimeFifoItem) message;

    CurrentThread() -> checkStack();

    mailBox.add( & foo );
}

int
Recv::remove()
{
    AwesimeFifoItem foo;
    mailBox.remove(&foo);
    return( (int) foo );
}
	
